"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelCopy = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _detail_panel_list_item = require("../detail_panel_list_item");
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Copy to clipboard component in Session view detail panel.
 */
const DetailPanelCopy = ({
  children,
  textToCopy,
  tooltipContent,
  display = 'inlineBlock'
}) => {
  const styles = (0, _styles.useStyles)();
  const props = {
    copy: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: textToCopy,
      tooltipProps: {
        display
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      css: styles.copyButton,
      onClick: copy,
      display: "base",
      iconType: "copyClipboard",
      size: "xs",
      "aria-label": _i18n.i18n.translate('xpack.sessionView.detailPanelCopy.copyButton', {
        defaultMessage: 'Copy'
      })
    }))
  };
  if (display === 'block') {
    props.display = display;
  }
  return /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, props, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
};
exports.DetailPanelCopy = DetailPanelCopy;