"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditName = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _use_connector = require("../../hooks/api/use_connector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditName = ({
  connector,
  isDisabled
}) => {
  const [isEditing, setIsEditing] = (0, _react2.useState)(false);
  const [newName, setNewName] = (0, _react2.useState)(connector.name || _i18n_string.CONNECTOR_LABEL);
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  (0, _react2.useEffect)(() => setNewName(connector.name), [connector.name]);
  const {
    isLoading,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputName => {
      const body = {
        name: inputName
      };
      await http.post(`/internal/serverless_search/connectors/${connector.id}/name`, {
        body: JSON.stringify(body)
      });
      return inputName;
    },
    onSuccess: successData => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          name: successData
        }
      });
      queryClient.invalidateQueries(queryKey);
      setIsEditing(false);
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, !isEditing ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "serverlessSearchConnectorName"
  }, /*#__PURE__*/_react2.default.createElement("h1", null, connector.name || _i18n.i18n.translate('xpack.serverlessSearch.connector.chooseName', {
    defaultMessage: 'Choose a name for your connector'
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
              justify-content: center;
            `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "serverlessSearchEditNameButton",
    isDisabled: isDisabled,
    color: "text",
    iconType: "pencil",
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.connectors.editNameLabel', {
      defaultMessage: 'Edit connector name'
    }),
    onClick: () => setIsEditing(true)
  }))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.nameLabel', {
    defaultMessage: 'Name'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "serverlessSearchEditNameFieldText",
    onChange: event => setNewName(event.target.value),
    value: newName
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                justify-content: center;
              `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchSaveNameButton",
    color: "primary",
    fill: true,
    type: "submit",
    onClick: () => mutate(newName),
    size: "s",
    isLoading: isLoading
  }, _i18n_string.SAVE_LABEL)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                justify-content: center;
              `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchCancelNameButton",
    size: "s",
    isLoading: isLoading,
    onClick: () => {
      setNewName(connector.name);
      setIsEditing(false);
    }
  }, _i18n_string.CANCEL_LABEL)))));
};
exports.EditName = EditName;