"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n_string = require("../../../../../common/i18n_string");
var _use_create_api_key = require("../../../hooks/api/use_create_api_key");
var _use_api_key = require("../../../hooks/api/use_api_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeyPanel = ({
  connector
}) => {
  const {
    data,
    isLoading,
    mutate
  } = (0, _use_create_api_key.useCreateApiKey)();
  const {
    data: apiKeysData
  } = (0, _use_api_key.useGetApiKeys)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.apiKeyTitle', {
    defaultMessage: 'Prepare an API key'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n_string.OPTIONAL_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectors.config.apiKeyDescription",
    defaultMessage: "You can limit the connector's API key to only have access to the above index. Once created, use this key to set the {apiKey} variable in your {config} file.",
    values: {
      apiKey: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "api_key"),
      config: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "config.yml")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchApiKeyPanelNewApiKeyButton",
    isDisabled: !connector.index_name || !(apiKeysData !== null && apiKeysData !== void 0 && apiKeysData.canManageOwnApiKey),
    isLoading: isLoading,
    iconType: "plusInCircle",
    color: "primary",
    onClick: () => {
      if (connector.index_name) {
        mutate({
          name: `${connector.index_name}-connector`,
          role_descriptors: {
            [`${connector.index_name}-connector-role`]: {
              cluster: ['monitor'],
              index: [{
                names: [connector.index_name, connector.index_name.replace(/^(?:search-)?(.*)$/, '.search-acl-filter-$1'), `${_searchConnectors.CONNECTORS_INDEX}*`],
                privileges: ['all']
              }]
            }
          }
        });
      }
    }
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.createApikeyLabel', {
    defaultMessage: 'New API key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), Boolean(data) && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, data === null || data === void 0 ? void 0 : data.encoded));
};
exports.ApiKeyPanel = ApiKeyPanel;