"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stripNullishRequestParameters = stripNullishRequestParameters;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function stripNullishRequestParameters(params) {
  return (0, _lodash.omitBy)({
    path: params.params,
    query: params.query,
    body: params.body
  }, val => val === null || val === undefined || (0, _lodash.isPlainObject)(val) && (0, _lodash.isEmpty)(val));
}