"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCriblPackagePolicyPostCreateOrUpdateCallback = void 0;
var _put_cribl_routing_pipeline = require("./handlers/put_cribl_routing_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isCriblPackagePolicy = packagePolicy => {
  var _packagePolicy$packag;
  return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === 'cribl';
};
const getCriblPackagePolicyPostCreateOrUpdateCallback = async (esClient, packagePolicy, logger) => {
  if (isCriblPackagePolicy(packagePolicy)) {
    return (0, _put_cribl_routing_pipeline.putCriblRoutingPipeline)(esClient, packagePolicy, logger);
  }
};
exports.getCriblPackagePolicyPostCreateOrUpdateCallback = getCriblPackagePolicyPostCreateOrUpdateCallback;