"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildResponseActionsQuery = void 0;
var _constants = require("@kbn/osquery-plugin/common/constants");
var _constants2 = require("../../../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointFieldsLimited = ['EndpointActions.action_id', 'EndpointActions.input_type', 'EndpointActions.expiration', 'EndpointActions.data.command'];
const buildResponseActionsQuery = ({
  alertIds,
  sort
}, authz) => {
  const fields = authz !== null && authz !== void 0 && authz.canAccessEndpointActionsLogManagement ? [{
    field: '*'
  }, {
    field: 'EndpointActions.*',
    include_unmapped: true
  }] : ['@timestamp', 'action_id', 'input_type', ...EndpointFieldsLimited];
  const dslQuery = {
    allow_no_indices: true,
    index: [_constants2.ENDPOINT_ACTIONS_INDEX, _constants.OSQUERY_ACTIONS_INDEX],
    ignore_unavailable: true,
    fields,
    _source: false,
    query: {
      bool: {
        minimum_should_match: 2,
        should: [{
          term: {
            type: 'INPUT_ACTION'
          }
        }, {
          terms: {
            alert_ids: alertIds
          }
        }, {
          terms: {
            'data.alert_id': alertIds
          }
        }]
      }
    },
    sort: [{
      [sort.field]: {
        order: sort.order
      }
    }]
  };
  return dslQuery;
};
exports.buildResponseActionsQuery = buildResponseActionsQuery;