"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitoringEntitySourceTypeNameMappings = exports.monitoringEntitySourceTypeName = exports.monitoringEntitySourceType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const monitoringEntitySourceTypeName = exports.monitoringEntitySourceTypeName = 'entity-analytics-monitoring-entity-source';
const monitoringEntitySourceTypeNameMappings = exports.monitoringEntitySourceTypeNameMappings = {
  dynamic: false,
  properties: {
    type: {
      type: 'keyword'
    },
    name: {
      type: 'keyword'
    },
    managed: {
      type: 'boolean'
    },
    enabled: {
      type: 'boolean'
    },
    error: {
      type: 'keyword'
    },
    integrationName: {
      type: 'keyword'
    },
    matchers: {
      type: 'object',
      dynamic: false
    },
    filter: {
      dynamic: false,
      type: 'object'
    }
  }
};
const monitoringEntitySourceType = exports.monitoringEntitySourceType = {
  name: monitoringEntitySourceTypeName,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: monitoringEntitySourceTypeNameMappings
};