"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityEngineDescriptorTypeName = exports.entityEngineDescriptorTypeMappings = exports.entityEngineDescriptorType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityEngineDescriptorTypeName = exports.entityEngineDescriptorTypeName = 'entity-engine-status';
const entityEngineDescriptorTypeMappings = exports.entityEngineDescriptorTypeMappings = {
  dynamic: false,
  properties: {
    indexPattern: {
      type: 'keyword'
    },
    filter: {
      type: 'keyword'
    },
    type: {
      type: 'keyword' // EntityType: user | host
    },
    status: {
      type: 'keyword' // EngineStatus: installing | started | stopped
    },
    fieldHistoryLength: {
      type: 'integer',
      index: false
    },
    timestampField: {
      type: 'keyword' // timestampFieldName : @timestamp | event.ingested
    }
  }
};
const version1 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      fieldHistoryLength: {
        type: 'integer',
        index: false
      },
      timestampField: {
        type: 'keyword'
      }
    }
  }, {
    type: 'data_backfill',
    backfillFn: document => {
      return {
        attributes: {
          ...document.attributes,
          fieldHistoryLength: 10
        }
      };
    }
  }]
};
const version2 = {
  changes: [{
    type: 'data_backfill',
    backfillFn: document => {
      return {
        attributes: {
          ..._constants.defaultOptions,
          ...document.attributes
        }
      };
    }
  }]
};
const entityEngineDescriptorType = exports.entityEngineDescriptorType = {
  name: entityEngineDescriptorTypeName,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: entityEngineDescriptorTypeMappings,
  modelVersions: {
    1: version1,
    2: version2
  }
};