"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultOptions = exports.MAX_SEARCH_RESPONSE_SIZE = exports.ENTITY_STORE_STATUS = exports.ENGINE_STATUS = exports.DEFAULT_TIMESTAMP_FIELD = exports.DEFAULT_TIMEOUT = exports.DEFAULT_SYNC_DELAY = exports.DEFAULT_LOOKBACK_PERIOD = exports.DEFAULT_KQL_FILTER = exports.DEFAULT_INDEX_PATTERNS = exports.DEFAULT_FREQUENCY = exports.DEFAULT_FIELD_HISTORY_LENGTH = exports.DEFAULT_DOCS_PER_SECOND = void 0;
var _constants = require("./tasks/field_retention_enrichment/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LOOKBACK_PERIOD = exports.DEFAULT_LOOKBACK_PERIOD = '24h';
const DEFAULT_FIELD_HISTORY_LENGTH = exports.DEFAULT_FIELD_HISTORY_LENGTH = 10;
const DEFAULT_SYNC_DELAY = exports.DEFAULT_SYNC_DELAY = '1m';
const DEFAULT_TIMEOUT = exports.DEFAULT_TIMEOUT = '180s';
const DEFAULT_FREQUENCY = exports.DEFAULT_FREQUENCY = '1m';
const DEFAULT_DOCS_PER_SECOND = exports.DEFAULT_DOCS_PER_SECOND = undefined;
const DEFAULT_INDEX_PATTERNS = exports.DEFAULT_INDEX_PATTERNS = '';
const DEFAULT_KQL_FILTER = exports.DEFAULT_KQL_FILTER = '';
const DEFAULT_TIMESTAMP_FIELD = exports.DEFAULT_TIMESTAMP_FIELD = '@timestamp';
const defaultOptions = exports.defaultOptions = {
  delay: DEFAULT_SYNC_DELAY,
  timeout: DEFAULT_TIMEOUT,
  frequency: DEFAULT_FREQUENCY,
  docsPerSecond: DEFAULT_DOCS_PER_SECOND,
  lookbackPeriod: DEFAULT_LOOKBACK_PERIOD,
  fieldHistoryLength: DEFAULT_FIELD_HISTORY_LENGTH,
  indexPattern: DEFAULT_INDEX_PATTERNS,
  filter: DEFAULT_KQL_FILTER,
  enrichPolicyExecutionInterval: _constants.DEFAULT_INTERVAL,
  timestampField: DEFAULT_TIMESTAMP_FIELD
};
const ENGINE_STATUS = exports.ENGINE_STATUS = {
  INSTALLING: 'installing',
  STARTED: 'started',
  STOPPED: 'stopped',
  UPDATING: 'updating',
  ERROR: 'error'
};
const ENTITY_STORE_STATUS = exports.ENTITY_STORE_STATUS = {
  RUNNING: 'running',
  STOPPED: 'stopped',
  INSTALLING: 'installing',
  NOT_INSTALLED: 'not_installed',
  ERROR: 'error'
};
const MAX_SEARCH_RESPONSE_SIZE = exports.MAX_SEARCH_RESPONSE_SIZE = 10_000;