"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapNewTermsAlerts = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _field_names = require("../../../../../common/field_maps/field_names");
var _reason_formatters = require("../utils/reason_formatters");
var _transform_hit_to_alert = require("../factories/utils/transform_hit_to_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapNewTermsAlerts = ({
  sharedParams,
  eventsAndTerms
}) => {
  return eventsAndTerms.map(eventAndTerms => {
    const id = (0, _objectHash.default)([eventAndTerms.event._index, eventAndTerms.event._id, String(eventAndTerms.event._version), `${sharedParams.spaceId}:${sharedParams.completeRule.alertId}`, eventAndTerms.newTerms]);
    const baseAlert = (0, _transform_hit_to_alert.transformHitToAlert)({
      sharedParams,
      doc: eventAndTerms.event,
      applyOverrides: true,
      buildReasonMessage: _reason_formatters.buildReasonMessageForNewTermsAlert,
      alertUuid: id
    });
    return {
      _id: id,
      _index: '',
      _source: {
        ...baseAlert,
        [_field_names.ALERT_NEW_TERMS]: eventAndTerms.newTerms
      }
    };
  });
};
exports.wrapNewTermsAlerts = wrapNewTermsAlerts;