"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.revertPrebuiltRules = void 0;
var _constants = require("../../../../../../common/constants");
var _promise_pool = require("../../../../../utils/promise_pool");
var _with_security_span = require("../../../../../utils/with_security_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Merges customization adjacent fields (actions, exception_list, etc.) and updates rule to provided rule asset.
 * This implements a chunked approach to not saturate network connections and
 * avoid being a "noisy neighbor".
 * @param detectionRulesClient IDetectionRulesClient
 * @param ruleVersions The rules versions to update
 */
const revertPrebuiltRules = async (detectionRulesClient, ruleVersions) => (0, _with_security_span.withSecuritySpan)('revertPrebuiltRule', async () => {
  const result = await (0, _promise_pool.initPromisePool)({
    concurrency: _constants.MAX_RULES_TO_UPDATE_IN_PARALLEL,
    items: ruleVersions,
    executor: async ({
      current,
      target
    }) => {
      return detectionRulesClient.revertPrebuiltRule({
        ruleAsset: target,
        existingRule: current
      });
    }
  });
  return result;
});
exports.revertPrebuiltRules = revertPrebuiltRules;