"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessHash = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HashFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const ProcessHash = exports.ProcessHash = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  processHashSha256,
  scopeId
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(processHashSha256)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(HashFlexGroup, {
    alignItems: "center",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "div"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.hash.sha256",
    iconType: "number",
    value: processHashSha256,
    fieldType: "keyword",
    isAggregatable: true
  })));
});
ProcessHash.displayName = 'ProcessHash';