"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineTypes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _timeline = require("../../../../common/api/timeline");
var _types = require("../../../app/types");
var _link_to = require("../../../common/components/link_to");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("./types");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineTypes = ({
  defaultTimelineCount,
  templateTimelineCount
}) => {
  const {
    formatUrl,
    search: urlSearch
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.timelines);
  const {
    navigateToUrl
  } = (0, _kibana.useKibana)().services.application;
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const [timelineType, setTimelineTypes] = (0, _react.useState)(tabName === _timeline.TimelineTypeEnum.default || tabName === _timeline.TimelineTypeEnum.template ? tabName : _timeline.TimelineTypeEnum.default);
  const timelineUrl = (0, _react.useMemo)(() => {
    return formatUrl((0, _link_to.getTimelineTabsUrl)(_timeline.TimelineTypeEnum.default, urlSearch));
  }, [formatUrl, urlSearch]);
  const templateUrl = (0, _react.useMemo)(() => {
    return formatUrl((0, _link_to.getTimelineTabsUrl)(_timeline.TimelineTypeEnum.template, urlSearch));
  }, [formatUrl, urlSearch]);
  const goToTimeline = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToUrl(timelineUrl);
  }, [navigateToUrl, timelineUrl]);
  const goToTemplateTimeline = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToUrl(templateUrl);
  }, [navigateToUrl, templateUrl]);
  const getFilterOrTabs = (0, _react.useCallback)(timelineTabsStyle => [{
    id: _timeline.TimelineTypeEnum.default,
    name: i18n.TAB_TIMELINES,
    href: timelineUrl,
    disabled: false,
    onClick: timelineTabsStyle === _types2.TimelineTabsStyle.tab ? goToTimeline : _fp.noop
  }, {
    id: _timeline.TimelineTypeEnum.template,
    name: i18n.TAB_TEMPLATES,
    href: templateUrl,
    disabled: false,
    onClick: timelineTabsStyle === _types2.TimelineTabsStyle.tab ? goToTemplateTimeline : _fp.noop
  }], [timelineUrl, templateUrl, goToTimeline, goToTemplateTimeline]);
  const onFilterClicked = (0, _react.useCallback)((tabId, tabStyle) => {
    setTimelineTypes(tabId);
  }, [setTimelineTypes]);
  const timelineTabs = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      "data-test-subj": "open-timeline-subtabs"
    }, getFilterOrTabs(_types2.TimelineTabsStyle.tab).map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": `timeline-${_types2.TimelineTabsStyle.tab}-${tab.id}`,
      isSelected: tab.id === tabName,
      disabled: tab.disabled,
      key: `timeline-${_types2.TimelineTabsStyle.tab}-${tab.id}`,
      href: tab.href,
      onClick: ev => {
        tab.onClick(ev);
        onFilterClicked(tab.id, _types2.TimelineTabsStyle.tab);
      }
    }, tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tabName]);
  const timelineFilters = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, getFilterOrTabs(_types2.TimelineTabsStyle.filter).map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": `open-timeline-modal-body-${_types2.TimelineTabsStyle.filter}-${tab.id}`,
      isSelected: tab.id === timelineType,
      key: `timeline-${_types2.TimelineTabsStyle.filter}-${tab.id}`,
      onClick: ev => {
        tab.onClick(ev);
        onFilterClicked(tab.id, _types2.TimelineTabsStyle.filter);
      }
    }, tab.name)));
  }, [timelineType, getFilterOrTabs, onFilterClicked]);
  return {
    timelineType,
    timelineTabs,
    timelineFilters
  };
};
exports.useTimelineTypes = useTimelineTypes;