"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingStaticPanel = exports.LoadingStaticContentPanel = exports.LoadingPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpinnerFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-right: 5px;
`;
SpinnerFlexItem.displayName = 'SpinnerFlexItem';
const LoadingPanel = exports.LoadingPanel = /*#__PURE__*/_react.default.memo(({
  height = 'auto',
  showBorder = true,
  text,
  width,
  position = 'relative',
  zIndex = 'inherit'
}) => /*#__PURE__*/_react.default.createElement(LoadingStaticPanel, {
  className: "app-loading",
  height: height,
  width: width,
  position: position,
  zIndex: zIndex
}, /*#__PURE__*/_react.default.createElement(LoadingStaticContentPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  className: showBorder ? '' : 'euiPanel-loading-hide-border'
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  direction: "row",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(SpinnerFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "m"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, text)))))));
LoadingPanel.displayName = 'LoadingPanel';
const LoadingStaticPanel = exports.LoadingStaticPanel = _styledComponents.default.div`
  height: ${({
  height
}) => height};
  position: ${({
  position
}) => position};
  width: ${({
  width
}) => width};
  overflow: hidden;
  display: flex;
  flex-direction: column;
  justify-content: center;
  z-index: ${({
  zIndex
}) => zIndex};
`;
LoadingStaticPanel.displayName = 'LoadingStaticPanel';
const LoadingStaticContentPanel = exports.LoadingStaticContentPanel = _styledComponents.default.div`
  flex: 0 0 auto;
  align-self: center;
  text-align: center;
  height: fit-content;
  .euiPanel.euiPanel--paddingMedium {
    padding: 10px;
  }
`;
LoadingStaticContentPanel.displayName = 'LoadingStaticContentPanel';