"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopMigration = exports.RULES_DATA_INPUT_STOP_MIGRATION_SUCCESS = exports.RULES_DATA_INPUT_STOP_MIGRATION_ERROR = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _api_request_reducer = require("./common/api_request_reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULES_DATA_INPUT_STOP_MIGRATION_SUCCESS = exports.RULES_DATA_INPUT_STOP_MIGRATION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.service.stopMigrationSuccess', {
  defaultMessage: 'Migration stopped successfully.'
});
const RULES_DATA_INPUT_STOP_MIGRATION_ERROR = exports.RULES_DATA_INPUT_STOP_MIGRATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.service.stopMigrationError', {
  defaultMessage: 'Error stopping migration.'
});
const useStopMigration = onSuccess => {
  const {
    siemMigrations,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const [state, dispatch] = (0, _react.useReducer)(_api_request_reducer.reducer, _api_request_reducer.initialState);
  const stopMigration = (0, _react.useCallback)(migrationId => {
    (async () => {
      try {
        dispatch({
          type: 'start'
        });
        const {
          stopped
        } = await siemMigrations.rules.stopRuleMigration(migrationId);
        if (stopped) {
          notifications.toasts.addSuccess(RULES_DATA_INPUT_STOP_MIGRATION_SUCCESS);
        }
        dispatch({
          type: 'success'
        });
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (err) {
        var _err$body;
        const apiError = (_err$body = err.body) !== null && _err$body !== void 0 ? _err$body : err;
        notifications.toasts.addError(apiError, {
          title: RULES_DATA_INPUT_STOP_MIGRATION_ERROR
        });
        dispatch({
          type: 'error',
          error: apiError
        });
      }
    })();
  }, [siemMigrations.rules, notifications.toasts, onSuccess]);
  return {
    isLoading: state.loading,
    error: state.error,
    stopMigration
  };
};
exports.useStopMigration = useStopMigration;