"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetIntegrationsStats = exports.GET_INTEGRATIONS_STATS_ERROR = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _api_request_reducer = require("./common/api_request_reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_INTEGRATIONS_STATS_ERROR = exports.GET_INTEGRATIONS_STATS_ERROR = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.service.getIntegrationsStatsError', {
  defaultMessage: 'Failed to fetch integrations stats'
});
const useGetIntegrationsStats = onSuccess => {
  const {
    siemMigrations,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const [state, dispatch] = (0, _react.useReducer)(_api_request_reducer.reducer, _api_request_reducer.initialState);
  const getIntegrationsStats = (0, _react.useCallback)(() => {
    (async () => {
      try {
        dispatch({
          type: 'start'
        });
        const integrationsStats = await siemMigrations.rules.api.getIntegrationsStats();
        onSuccess(integrationsStats);
        dispatch({
          type: 'success'
        });
      } catch (err) {
        var _err$body;
        const apiError = (_err$body = err.body) !== null && _err$body !== void 0 ? _err$body : err;
        notifications.toasts.addError(apiError, {
          title: GET_INTEGRATIONS_STATS_ERROR
        });
        dispatch({
          type: 'error',
          error: apiError
        });
      }
    })();
  }, [siemMigrations.rules.api, notifications.toasts, onSuccess]);
  return {
    isLoading: state.loading,
    error: state.error,
    getIntegrationsStats
  };
};
exports.useGetIntegrationsStats = useGetIntegrationsStats;