"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statReducer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statReducer = (state, action) => {
  switch (action.type) {
    case 'setIsLoading':
      return {
        ...state,
        isLoading: action.isLoading
      };
    case 'setUpdatedAt':
      return {
        ...state,
        updatedAt: action.updatedAt
      };
    case 'setStat':
      return {
        ...state,
        stat: action.stat
      };
    case 'setPercentage':
      return {
        ...state,
        percentage: action.percentage
      };
    default:
      throw new Error();
  }
};
exports.statReducer = statReducer;