"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertsCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _css = require("@emotion/css");
var _links = require("../../../../../common/components/links");
var _constants = require("../../../../constants");
var _card_content_asset_panel = require("../common/card_content_asset_panel");
var _card_callout = require("../common/card_callout");
var _card_subdued_text = require("../common/card_subdued_text");
var i18n = _interopRequireWildcard(require("./translations"));
var _card_selector_list = require("../common/card_selector_list");
var _alerts_card_config = require("./alerts_card_config");
var _onboarding_context = require("../../../onboarding_context");
var _constants2 = require("./constants");
var _use_stored_state = require("../../../hooks/use_stored_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsCard = ({
  isCardComplete,
  setExpandedCardId,
  setComplete,
  isCardAvailable
}) => {
  const {
    spaceId
  } = (0, _onboarding_context.useOnboardingContext)();
  const [selectedAlertId, setSelectedAlertId] = (0, _use_stored_state.useStoredSelectedCardItemId)('alerts', spaceId, _constants2.DEFAULT_ALERTS_CARD_ITEM_SELECTED.id);
  const selectedCardItem = (0, _react.useMemo)(() => _alerts_card_config.ALERTS_CARD_ITEMS_BY_ID[selectedAlertId], [selectedAlertId]);
  const isIntegrationsCardComplete = (0, _react.useMemo)(() => isCardComplete(_constants.OnboardingCardId.integrations), [isCardComplete]);
  const isIntegrationsCardAvailable = (0, _react.useMemo)(() => isCardAvailable(_constants.OnboardingCardId.integrations), [isCardAvailable]);
  const expandIntegrationsCard = (0, _react.useCallback)(() => {
    setExpandedCardId(_constants.OnboardingCardId.integrations, {
      scroll: true
    });
  }, [setExpandedCardId]);
  const onSelectCard = (0, _react.useCallback)(item => {
    setSelectedAlertId(item.id);
  }, [setSelectedAlertId]);
  return /*#__PURE__*/_react.default.createElement(_card_content_asset_panel.OnboardingCardContentAssetPanel, {
    asset: selectedCardItem.asset
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl",
    justifyContent: "flexStart",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _css.css)`
            width: 100%;
          `
  }, /*#__PURE__*/_react.default.createElement(_card_subdued_text.CardSubduedText, {
    "data-test-subj": "alertsCardDescription",
    size: "s"
  }, i18n.ALERTS_CARD_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_card_selector_list.CardSelectorList, {
    title: i18n.ALERTS_CARD_STEP_SELECTOR_TITLE,
    items: _alerts_card_config.ALERTS_CARD_ITEMS,
    onSelect: onSelectCard,
    selectedItem: selectedCardItem,
    cardId: _constants.OnboardingCardId.alerts
  }), isIntegrationsCardAvailable && !isIntegrationsCardComplete && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_card_callout.CardCallOut, {
    color: "primary",
    icon: "info",
    text: i18n.ALERTS_CARD_CALLOUT_INTEGRATIONS_TEXT,
    action: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: expandIntegrationsCard
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.ALERTS_CARD_CALLOUT_INTEGRATIONS_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      color: "primary",
      size: "s"
    }))))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "alertsCardButton",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    onClick: () => setComplete(true),
    deepLinkId: _securitySolutionNavigation.SecurityPageName.alerts,
    fill: true,
    isDisabled: isIntegrationsCardAvailable && !isIntegrationsCardComplete
  }, i18n.ALERTS_CARD_VIEW_ALERTS_BUTTON))));
};

// eslint-disable-next-line import/no-default-export
exports.AlertsCard = AlertsCard;
var _default = exports.default = AlertsCard;