"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowInsights = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _workflow_insights = require("../../../../../../../../common/endpoint/types/workflow_insights");
var _translations = require("../../../../../../../common/translations");
var _use_fetch_insights = require("../../../hooks/insights/use_fetch_insights");
var _use_trigger_scan = require("../../../hooks/insights/use_trigger_scan");
var _use_fetch_ongoing_tasks = require("../../../hooks/insights/use_fetch_ongoing_tasks");
var _workflow_insights_results = require("./workflow_insights_results");
var _workflow_insights_scan = require("./workflow_insights_scan");
var _translations2 = require("../../../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkflowInsights = exports.WorkflowInsights = /*#__PURE__*/_react.default.memo(({
  endpointId
}) => {
  const [isScanButtonDisabled, setIsScanButtonDisabled] = (0, _react.useState)(true);
  const [scanCompleted, setIsScanCompleted] = (0, _react.useState)(false);
  const [userTriggeredScan, setUserTriggeredScan] = (0, _react.useState)(false);
  const [insightGenerationFailures, setInsightGenerationFailures] = (0, _react.useState)(false);
  const [expectedCount, setExpectedCount] = (0, _react.useState)(null);
  const onInsightGenerationFailure = () => {
    setInsightGenerationFailures(true);
  };
  const [setScanOngoing, setScanCompleted] = [() => setIsScanCompleted(false), () => setIsScanCompleted(true)];

  // refetch is automatically triggered when expectedCount changes
  const {
    data: insights,
    isFetching: isFetchingInsights
  } = (0, _use_fetch_insights.useFetchInsights)({
    endpointId,
    onSuccess: setScanCompleted,
    scanCompleted,
    expectedCount
  });
  const {
    data: latestScan,
    isLoading: isLoadingLatestScan,
    refetch: refetchLatestScan
  } = (0, _use_fetch_ongoing_tasks.useFetchLatestScan)({
    endpointId,
    isPolling: isScanButtonDisabled,
    onSuccess: setExpectedCount,
    onInsightGenerationFailure
  });
  const {
    mutate: triggerScan,
    isLoading: isPostDefendInsightsLoading
  } = (0, _use_trigger_scan.useTriggerScan)({
    onSuccess: refetchLatestScan
  });
  (0, _react.useEffect)(() => {
    setExpectedCount(null);
    setIsScanCompleted(false);
  }, [endpointId, setExpectedCount, setIsScanCompleted]);
  (0, _react.useEffect)(() => {
    const isInsightRunning = (latestScan === null || latestScan === void 0 ? void 0 : latestScan.status) === _elasticAssistantCommon.DefendInsightStatusEnum.running;
    const hasPendingInsights = expectedCount !== null && (insights === null || insights === void 0 ? void 0 : insights.length) !== expectedCount;
    const initialFetchNotStarted = expectedCount === null;
    setIsScanButtonDisabled(isPostDefendInsightsLoading || isLoadingLatestScan || isInsightRunning || hasPendingInsights || isFetchingInsights || initialFetchNotStarted // hold off until we know `expectedCount` (even 0)
    );
  }, [endpointId, isPostDefendInsightsLoading, isLoadingLatestScan, latestScan, insights, expectedCount, isFetchingInsights]);
  const lastResultCaption = (0, _react.useMemo)(() => {
    if (!(insights !== null && insights !== void 0 && insights.length)) {
      return null;
    }
    const latestTimestamp = insights.map(insight => _moment.default.utc(insight['@timestamp'])).sort((a, b) => b.diff(a))[0];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 'xs'
    }, `${_translations2.WORKFLOW_INSIGHTS.titleRight} ${latestTimestamp.local().fromNow()}`);
  }, [insights]);
  const activeInsights = (0, _react.useMemo)(() => {
    if (isScanButtonDisabled) {
      return [];
    }
    return (insights !== null && insights !== void 0 ? insights : []).filter(insight => insight.action.type === _workflow_insights.ActionType.Refreshed);
  }, [isScanButtonDisabled, insights]);
  const onScanButtonClick = (0, _react.useCallback)(({
    actionTypeId,
    connectorId
  }) => {
    if (insightGenerationFailures) {
      setInsightGenerationFailures(false);
    }
    setScanOngoing();
    setExpectedCount(null);
    if (!userTriggeredScan) {
      setUserTriggeredScan(true);
    }
    triggerScan({
      endpointId,
      actionTypeId,
      connectorId
    });
  }, [insightGenerationFailures, setScanOngoing, userTriggeredScan, triggerScan, endpointId, setExpectedCount]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": 'endpointDetailsInsightsWrapper',
    id: 'workflow-insights-wrapper',
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'm'
    }, /*#__PURE__*/_react.default.createElement("h4", null, _translations2.WORKFLOW_INSIGHTS.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      alignment: 'middle',
      label: _translations.TECHNICAL_PREVIEW,
      tooltipContent: _translations.TECHNICAL_PREVIEW_TOOLTIP,
      size: "s",
      iconType: 'beaker',
      "data-test-subj": 'workflow-insights-tech-preview-badge'
    }))),
    initialIsOpen: true,
    extraAction: lastResultCaption,
    paddingSize: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_workflow_insights_scan.WorkflowInsightsScanSection, {
    isScanButtonDisabled: isScanButtonDisabled,
    onScanButtonClick: onScanButtonClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_workflow_insights_results.WorkflowInsightsResults, {
    results: activeInsights,
    scanCompleted: !isScanButtonDisabled && !insightGenerationFailures && scanCompleted && userTriggeredScan,
    endpointId: endpointId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
});
WorkflowInsights.displayName = 'WorkflowInsights';