"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _pages = require("./users/pages");
var _pages2 = require("./hosts/pages");
var _pages3 = require("./network/pages");
var _types = require("../app/types");
var _constants = require("../../common/constants");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _landing = require("./landing");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExploreLanding = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_landing.ExploreLandingPage, null));
const NetworkRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_pages3.NetworkContainer, null));
const UsersRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_pages.UsersContainer, null));
const HostsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_pages2.HostsContainer, null));
const routes = exports.routes = [{
  path: _constants.EXPLORE_PATH,
  exact: true,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(ExploreLanding, _types.SecurityPageName.exploreLanding, {
    omitSpyRoute: true
  })
}, {
  path: _constants.NETWORK_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(NetworkRoutes, _types.SecurityPageName.network, {
    omitSpyRoute: true
  })
}, {
  path: _constants.USERS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(UsersRoutes, _types.SecurityPageName.users, {
    omitSpyRoute: true
  })
}, {
  path: _constants.HOSTS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(HostsRoutes, _types.SecurityPageName.hosts, {
    omitSpyRoute: true
  })
}];