"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricEmbeddable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../data_view_manager/constants");
var _utils = require("./utils");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_HEIGHT = 36;
const MetricEmbeddableComponent = ({
  fields,
  id,
  inspectTitle,
  timerange
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    className: "metricEmbeddable"
  }, fields.map(field => /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    key: `stat-items-field-${field.key}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, field.icon && /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: field.icon,
    color: field.color,
    size: "l",
    "data-test-subj": "stat-icon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, field.lensAttributes && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stat-title"
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-metric",
    height: CHART_HEIGHT,
    id: `${id}-${field.key}-metric-embeddable`,
    lensAttributes: field.lensAttributes,
    timerange: timerange,
    inspectTitle: inspectTitle,
    scopeId: newDataViewPickerEnabled ? _constants.DataViewManagerScopeName.explore : _constants.DataViewManagerScopeName.default
  }))), field.description != null && /*#__PURE__*/_react.default.createElement(_utils.FlexItem, null, /*#__PURE__*/_react.default.createElement(_utils.StatValue, null, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "stat-title"
  }, field.description)))))));
};
const MetricEmbeddable = exports.MetricEmbeddable = /*#__PURE__*/_react.default.memo(MetricEmbeddableComponent);