"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TitleBadge = exports.TitleBadge = /*#__PURE__*/(0, _react.memo)(({
  title,
  badgeString
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const itemStyles = (0, _css.css)`
    border-right: ${euiTheme.border.thin};
    padding: ${euiTheme.size.xs} ${euiTheme.size.s} ${euiTheme.size.xs} 0;
  `;
  const titleTextStyles = (0, _css.css)`
    width: max-content;
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: titleTextStyles,
    grow: true,
    size: "xs"
  }, `${title}:`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: itemStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, badgeString)));
});
TitleBadge.displayName = 'TitleBadge';