"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreDonutChart = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _chart_label = require("../../../overview/components/detection_response/alerts_by_status/chart_label");
var _use_risk_donut_chart_data = require("./use_risk_donut_chart_data");
var _donutchart = require("../../../common/components/charts/donutchart");
var _legend = require("../../../common/components/charts/legend");
var _use_risk_score_fill_color = require("./use_risk_score_fill_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DONUT_HEIGHT = 120;
const DonutContainer = (0, _styled.default)(_eui.EuiFlexItem)`
  padding-right: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.xxl};
  padding-left: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.m};
`;
const StyledLegendItems = (0, _styled.default)(_eui.EuiFlexItem)`
  justify-content: center;
`;
const RiskScoreDonutChart = ({
  severityCount
}) => {
  const [donutChartData, legendItems, total] = (0, _use_risk_donut_chart_data.useRiskDonutChartData)(severityCount);
  const fillColor = (0, _use_risk_score_fill_color.useRiskScoreFillColor)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    "data-test-subj": "risk-score-donut-chart"
  }, /*#__PURE__*/_react.default.createElement(StyledLegendItems, {
    grow: false
  }, legendItems.length > 0 && /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    legendItems: legendItems
  })), /*#__PURE__*/_react.default.createElement(DonutContainer, {
    grow: false,
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_donutchart.DonutChart, {
    data: donutChartData !== null && donutChartData !== void 0 ? donutChartData : null,
    fillColor: fillColor,
    height: DONUT_HEIGHT,
    label: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskScore.donut_chart.totalLabel', {
      defaultMessage: 'Total'
    }),
    title: /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
      count: total
    }),
    totalCount: total
  })));
};
exports.RiskScoreDonutChart = RiskScoreDonutChart;