"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActivityPrivilegedUsersPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _links = require("../../../../../common/components/links");
var _header_section = require("../../../../../common/components/header_section");
var _constants = require("./constants");
var _esql_dashboard_panel = require("../../../privileged_user_monitoring_onboarding/components/esql_dashboard_panel/esql_dashboard_panel");
var _hooks = require("./hooks");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PICK_VISUALIZATION_LEGEND = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.pickVisualizationLegend', {
  defaultMessage: 'Select a visualization to display'
});
const TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.title', {
  defaultMessage: 'Privileged user activity'
});
const UserActivityPrivilegedUsersPanel = ({
  sourcererDataView
}) => {
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(_constants.PRIVILEGED_USER_ACTIVITY_QUERY_ID);
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const [selectedToggleOption, setToggleOption] = (0, _react.useState)(_types.VisualizationToggleOptions.GRANTED_RIGHTS);
  const {
    getLensAttributes,
    columns,
    generateVisualizationQuery,
    generateTableQuery,
    hasLoadedDependencies
  } = (0, _hooks.usePrivilegedUserActivityParams)(selectedToggleOption, sourcererDataView);
  const stackByOptions = (0, _hooks.useStackByOptions)(selectedToggleOption);
  const setSelectedChartOptionCallback = (0, _react.useCallback)(event => {
    var _stackByOptions$find;
    setSelectedStackByOption((_stackByOptions$find = stackByOptions.find(co => co.value === event.target.value)) !== null && _stackByOptions$find !== void 0 ? _stackByOptions$find : stackByOptions[0]);
  }, [stackByOptions]);
  const defaultStackByOption = stackByOptions[0];
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(defaultStackByOption);
  const toggleOptions = (0, _hooks.useToggleOptions)();
  const {
    discoverUrl
  } = (0, _hooks.useDiscoverUrl)({
    generateTableQuery
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "severity-level-panel"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    id: _constants.PRIVILEGED_USER_ACTIVITY_QUERY_ID,
    showInspectButton: false,
    title: TITLE,
    titleSize: "s",
    outerDirection: "column",
    hideSubtitle: true
  }, generateTableQuery && /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    href: discoverUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.linkDescription",
    defaultMessage: "View all events"
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: toggleOptions,
    idSelected: selectedToggleOption,
    onChange: id => {
      setToggleOption(id);
      setSelectedStackByOption(defaultStackByOption);
    },
    legend: PICK_VISUALIZATION_LEGEND
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, stackByOptions.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    onChange: setSelectedChartOptionCallback,
    options: stackByOptions,
    prepend: _i18n.i18n.translate('xpack.securitySolution.genericDashboard.stackBy.label', {
      defaultMessage: 'Stack by'
    }),
    value: selectedStackByOption === null || selectedStackByOption === void 0 ? void 0 : selectedStackByOption.value
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), generateVisualizationQuery && generateTableQuery ? /*#__PURE__*/_react.default.createElement(_esql_dashboard_panel.EsqlDashboardPanel, {
    title: TITLE,
    stackByField: selectedStackByOption.value,
    timerange: {
      from,
      to
    },
    getLensAttributes: getLensAttributes,
    generateVisualizationQuery: generateVisualizationQuery,
    generateTableQuery: generateTableQuery,
    columns: columns,
    pageSize: _constants.PAGE_SIZE,
    showInspectTable: true
  }) :
  // If dependencies are loaded but the query generation functions are not available, show an error message
  hasLoadedDependencies && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.missingMappings.errorTitle",
      defaultMessage: "There was a problem rendering the visualization"
    }),
    color: "warning",
    iconType: "error"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.missingMappings.errorMessage",
    defaultMessage: "The required fields are not present in the data view."
  }))));
};
exports.UserActivityPrivilegedUsersPanel = UserActivityPrivilegedUsersPanel;