"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _network = require("../../../common/search_strategy/security_solution/network");
var _links = require("../../common/components/links");
var _truncatable_text = require("../../common/components/truncatable_text");
var _empty_value = require("../../common/components/empty_value");
var _network_details = require("../../flyout/network_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkDetailsComponent = ({
  ip
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openNetworkDetailsSidePanel = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _network_details.NetworkPanelKey,
        params: {
          ip,
          flowTarget: _network.FlowTargetSourceDest.source
        }
      }
    });
  }, [ip, openFlyout]);
  if (!ip) {
    return (0, _empty_value.getEmptyTagValue)();
  }
  return /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
    ip: ip,
    onClick: openNetworkDetailsSidePanel
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, null, ip));
};
const NetworkDetails = exports.NetworkDetails = /*#__PURE__*/_react.default.memo(NetworkDetailsComponent);
NetworkDetails.displayName = 'NetworkDetails';