"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostRiskScoreQueryId = exports.FIRST_RECORD_PAGINATION = void 0;
Object.defineProperty(exports, "RISK_SCORE_RANGES", {
  enumerable: true,
  get: function () {
    return _risk_engine.RISK_LEVEL_RANGES;
  }
});
exports.formatRiskScoreWholeNumber = exports.formatRiskScore = exports.UserRiskScoreQueryId = exports.SEVERITY_UI_SORT_ORDER = exports.RISK_SEVERITY_COLOUR = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _search_strategy = require("../../../common/search_strategy");
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-line @elastic/eui/no-restricted-eui-imports

const SEVERITY_UI_SORT_ORDER = exports.SEVERITY_UI_SORT_ORDER = [_search_strategy.RiskSeverity.Unknown, _search_strategy.RiskSeverity.Low, _search_strategy.RiskSeverity.Moderate, _search_strategy.RiskSeverity.High, _search_strategy.RiskSeverity.Critical];

/*
 * Map Risk severity to EUI severity color pattern as per spec:
 * https://eui.elastic.co/docs/patterns/severity/index.html#use-cases
 */
const RISK_SEVERITY_COLOUR = exports.RISK_SEVERITY_COLOUR = {
  [_search_strategy.RiskSeverity.Unknown]: _uiTheme.euiThemeVars.euiColorSeverityUnknown,
  [_search_strategy.RiskSeverity.Low]: _uiTheme.euiThemeVars.euiColorSeverityNeutral,
  [_search_strategy.RiskSeverity.Moderate]: _uiTheme.euiThemeVars.euiColorSeverityWarning,
  [_search_strategy.RiskSeverity.High]: _uiTheme.euiThemeVars.euiColorSeverityRisk,
  [_search_strategy.RiskSeverity.Critical]: _uiTheme.euiThemeVars.euiColorSeverityDanger
};

// TODO #173073 @tiansivive Add to utilities in `src/platform/packages/shared/kbn-utility-types`
let UserRiskScoreQueryId = exports.UserRiskScoreQueryId = /*#__PURE__*/function (UserRiskScoreQueryId) {
  UserRiskScoreQueryId["USERS_BY_RISK"] = "UsersByRisk";
  UserRiskScoreQueryId["USER_DETAILS_RISK_SCORE"] = "UserDetailsRiskScore";
  return UserRiskScoreQueryId;
}({});
let HostRiskScoreQueryId = exports.HostRiskScoreQueryId = /*#__PURE__*/function (HostRiskScoreQueryId) {
  HostRiskScoreQueryId["DEFAULT"] = "HostRiskScore";
  HostRiskScoreQueryId["HOST_DETAILS_RISK_SCORE"] = "HostDetailsRiskScore";
  HostRiskScoreQueryId["OVERVIEW_RISKY_HOSTS"] = "OverviewRiskyHosts";
  HostRiskScoreQueryId["HOSTS_BY_RISK"] = "HostsByRisk";
  return HostRiskScoreQueryId;
}({});
/**
 *
 * @returns risk score rounded with 2 digits after the decimal separator
 * @example
 * formatRiskScore(10.555) // '10.56'
 */
const formatRiskScore = riskScore => (Math.round(riskScore * 100) / 100).toFixed(2);
exports.formatRiskScore = formatRiskScore;
const formatRiskScoreWholeNumber = riskScore => (Math.round(riskScore * 100) / 100).toFixed(0);
exports.formatRiskScoreWholeNumber = formatRiskScoreWholeNumber;
const FIRST_RECORD_PAGINATION = exports.FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};