"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldUpgradeHeader = FieldUpgradeHeader;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _field_upgrade_state_info = require("./field_upgrade_state_info");
var _modified_badge = require("../badges/modified_badge");
var _translations = require("./translations");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldUpgradeHeader({
  fieldName,
  fieldUpgradeState,
  isCustomized
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "ruleUpgradeFieldDiffLabel",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, (0, _helpers.convertFieldToDisplayName)(fieldName))), isCustomized && /*#__PURE__*/_react.default.createElement(_modified_badge.ModifiedBadge, {
    tooltip: _translations.FIELD_MODIFIED_BADGE_DESCRIPTION
  }), /*#__PURE__*/_react.default.createElement(_field_upgrade_state_info.FieldUpgradeStateInfo, {
    state: fieldUpgradeState
  }));
}