"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineTitle = exports.Threshold = exports.ThreatMapping = exports.ThreatIndex = exports.SuppressAlertsDuration = exports.SuppressAlertsByField = exports.SavedQueryName = exports.RuleType = exports.RuleDefinitionSection = exports.RequiredFields = exports.Query = exports.NewTermsFields = exports.MissingFieldsStrategy = exports.MachineLearningJobList = exports.Index = exports.HistoryWindowSize = exports.Filters = exports.DataViewIndexPattern = exports.DataViewId = exports.AnomalyThreshold = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _rule_schema = require("../../../../../common/api/detection_engine/model/rule_schema");
var _utility_types = require("../../../../../common/utility_types");
var descriptionStepI18n = _interopRequireWildcard(require("../../../rule_creation_ui/components/description_step/translations"));
var _integrations_description = require("../../../common/components/related_integrations/integrations_description");
var _alert_suppression_label = require("../../../rule_creation_ui/components/description_step/alert_suppression_label");
var _use_get_saved_query = require("../../../common/use_get_saved_query");
var threatMatchI18n = _interopRequireWildcard(require("../../../../common/components/threat_match/translations"));
var timelinesI18n = _interopRequireWildcard(require("../../../../timelines/components/timeline/translations"));
var _ml_jobs_description = require("../../../rule_creation/components/ml_jobs_description/ml_jobs_description");
var _ml_job_link = require("../../../rule_creation/components/ml_job_link/ml_job_link");
var _use_security_jobs = require("../../../../common/components/ml_popover/hooks/use_security_jobs");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _badge_list = require("./badge_list");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_alert_suppression = require("../../logic/use_alert_suppression");
var _required_field_icon = require("./required_field_icon");
var _rule_definition_section = require("./rule_definition_section.styles");
var _helpers = require("./helpers");
var _use_default_index_pattern = require("../../hooks/use_default_index_pattern");
var _date_math = require("../../../../common/utils/date_math");
var _constants2 = require("../../../../common/constants");
var _translations5 = require("../../../rule_creation/components/eql_query_edit/translations");
var _use_data_view = require("./three_way_diff/final_edit/fields/hooks/use_data_view");
var _match_filters_to_index_pattern = require("../../../../common/components/query_bar/match_filters_to_index_pattern");
var _rule_field_name = require("./rule_field_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedQueryName = ({
  savedQueryName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "savedQueryNamePropertyValue"
}, savedQueryName);
exports.SavedQueryName = SavedQueryName;
const Filters = ({
  filters,
  dataViewId,
  index,
  'data-test-subj': dataTestSubj
}) => {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const useDataViewParams = dataViewId ? {
    dataViewId
  } : {
    indexPatterns: index !== null && index !== void 0 ? index : defaultIndexPattern
  };
  const {
    dataView
  } = (0, _use_data_view.useDataView)(useDataViewParams);
  const isEsql = filters.some(filter => {
    var _filter$query;
    return (filter === null || filter === void 0 ? void 0 : (_filter$query = filter.query) === null || _filter$query === void 0 ? void 0 : _filter$query.language) === 'esql';
  });
  if (!(dataView !== null && dataView !== void 0 && dataView.id) || isEsql) {
    return null;
  }
  const flattenedFilters = (0, _public.mapAndFlattenFilters)(filters);
  const matchedFilters = (0, _match_filters_to_index_pattern.matchFiltersToIndexPattern)(dataView.id, flattenedFilters);
  const styles = _rule_definition_section.filtersStyles;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSubj,
    className: styles.flexGroup,
    wrap: true,
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_public2.FilterItems, {
    filters: matchedFilters,
    indexPatterns: [dataView],
    readOnly: true
  }));
};
exports.Filters = Filters;
const Query = ({
  query,
  'data-test-subj': dataTestSubj = 'query'
}) => {
  const styles = _rule_definition_section.queryStyles;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    className: styles.content
  }, query);
};
exports.Query = Query;
const Index = ({
  index
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: index,
  "data-test-subj": "indexPropertyValue"
});
exports.Index = Index;
const DataViewId = ({
  dataViewId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "dataViewIdPropertyValue"
}, dataViewId);
exports.DataViewId = DataViewId;
const DataViewIndexPattern = ({
  dataViewId
}) => {
  const {
    data
  } = (0, _kibana_react.useKibana)().services;
  const [indexPattern, setIndexPattern] = _react.default.useState('');
  const [hasError, setHasError] = _react.default.useState(false);
  _react.default.useEffect(() => {
    data.dataViews.get(dataViewId).then(dataView => {
      setIndexPattern(dataView.getIndexPattern());
    }).catch(() => {
      setHasError(true);
    });
  }, [data, dataViewId]);
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, i18n.DATA_VIEW_INDEX_PATTERN_FETCH_ERROR_MESSAGE);
  }
  if (!indexPattern) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "dataViewIndexPatternPropertyValue"
  }, indexPattern);
};
exports.DataViewIndexPattern = DataViewIndexPattern;
const Threshold = ({
  threshold
}) => {
  let thresholdDescription = (0, _fp.isEmpty)(threshold.field[0]) ? `${descriptionStepI18n.THRESHOLD_RESULTS_ALL} >= ${threshold.value}` : `${descriptionStepI18n.THRESHOLD_RESULTS_AGGREGATED_BY} ${Array.isArray(threshold.field) ? threshold.field.join(',') : threshold.field} >= ${threshold.value}`;
  if (threshold.cardinality && threshold.cardinality.length > 0) {
    thresholdDescription = descriptionStepI18n.THRESHOLD_CARDINALITY(thresholdDescription, threshold.cardinality[0].field, threshold.cardinality[0].value);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "thresholdPropertyValue"
  }, thresholdDescription);
};
exports.Threshold = Threshold;
const AnomalyThreshold = ({
  anomalyThreshold
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "anomalyThresholdPropertyValue"
}, anomalyThreshold);
exports.AnomalyThreshold = AnomalyThreshold;
const MachineLearningJobList = ({
  jobIds,
  isInteractive
}) => {
  const {
    jobs: availableJobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  if (!jobIds) {
    return null;
  }
  const jobIdsArray = Array.isArray(jobIds) ? jobIds : [jobIds];
  const unavailableJobIds = jobIdsArray.filter(jobId => !availableJobs.some(job => job.id === jobId));
  if (isInteractive) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ml_jobs_description.MlJobsDescription, {
      jobIds: jobIdsArray
    }), /*#__PURE__*/_react.default.createElement(UnavailableMlJobs, {
      unavailableJobIds: unavailableJobIds
    }));
  }
  const relevantJobs = availableJobs.filter(job => jobIdsArray.includes(job.id));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, relevantJobs.map(job => {
    var _job$customSettings;
    return /*#__PURE__*/_react.default.createElement(_ml_job_link.MlJobLink, {
      key: job.id,
      jobId: job.id,
      jobName: (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name
    });
  }), /*#__PURE__*/_react.default.createElement(UnavailableMlJobs, {
    unavailableJobIds: unavailableJobIds
  }));
};
exports.MachineLearningJobList = MachineLearningJobList;
const UnavailableMlJobs = ({
  unavailableJobIds
}) => {
  return unavailableJobIds.map(jobId => /*#__PURE__*/_react.default.createElement("div", {
    key: jobId
  }, /*#__PURE__*/_react.default.createElement(UnavailableMlJobLink, {
    jobId: jobId
  })));
};
const UnavailableMlJobLink = ({
  jobId
}) => {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "question",
    onClick: togglePopover,
    "aria-label": i18n.MACHINE_LEARNING_JOB_NOT_AVAILABLE
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "span",
    color: "subdued",
    size: "s"
  }, jobId, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover
  }, i18n.MACHINE_LEARNING_JOB_NOT_AVAILABLE));
};
const getRuleTypeDescription = ruleType => {
  switch (ruleType) {
    case 'machine_learning':
      return descriptionStepI18n.ML_TYPE_DESCRIPTION;
    case 'query':
    case 'saved_query':
      return descriptionStepI18n.QUERY_TYPE_DESCRIPTION;
    case 'threshold':
      return descriptionStepI18n.THRESHOLD_TYPE_DESCRIPTION;
    case 'eql':
      return descriptionStepI18n.EQL_TYPE_DESCRIPTION;
    case 'esql':
      return descriptionStepI18n.ESQL_TYPE_DESCRIPTION;
    case 'threat_match':
      return descriptionStepI18n.THREAT_MATCH_TYPE_DESCRIPTION;
    case 'new_terms':
      return descriptionStepI18n.NEW_TERMS_TYPE_DESCRIPTION;
    default:
      return (0, _utility_types.assertUnreachable)(ruleType);
  }
};
const RuleType = ({
  type
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, getRuleTypeDescription(type));
exports.RuleType = RuleType;
const RequiredFields = ({
  requiredFields
}) => {
  const styles = (0, _rule_definition_section.useRequiredFieldsStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    "data-test-subj": "requiredFieldsPropertyValue",
    gutterSize: 's'
  }, requiredFields.map((rF, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: rF.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: 'xs'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_required_field_icon.RequiredFieldIcon, {
    type: rF.type,
    "data-test-subj": "field-type-icon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "requiredFieldsPropertyValueItem",
    className: styles.fieldNameText,
    grow: false,
    size: "xs"
  }, ` ${rF.name}${index + 1 !== requiredFields.length ? ', ' : ''}`))))));
};
exports.RequiredFields = RequiredFields;
const TimelineTitle = ({
  timelineTitle
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "timelineTemplatePropertyValue"
}, timelineTitle);
exports.TimelineTitle = TimelineTitle;
const ThreatIndex = ({
  threatIndex
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: threatIndex,
  "data-test-subj": "threatIndexPropertyValue"
});
exports.ThreatIndex = ThreatIndex;
const ThreatMapping = ({
  threatMapping
}) => {
  const description = threatMapping.reduce((accumThreatMaps, threatMap, threatMapIndex, {
    length: threatMappingLength
  }) => {
    const matches = threatMap.entries.reduce((accumItems, item, itemsIndex, {
      length: threatMapLength
    }) => {
      if (threatMapLength === 1) {
        return `${item.field} ${threatMatchI18n.MATCHES} ${item.value}`;
      } else if (itemsIndex === 0) {
        return `(${item.field} ${threatMatchI18n.MATCHES} ${item.value})`;
      } else {
        return `${accumItems} ${threatMatchI18n.AND} (${item.field} ${threatMatchI18n.MATCHES} ${item.value})`;
      }
    }, '');
    if (threatMappingLength === 1) {
      return `${matches}`;
    } else if (threatMapIndex === 0) {
      return `(${matches})`;
    } else {
      return `${accumThreatMaps} ${threatMatchI18n.OR} (${matches})`;
    }
  }, '');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "threatMappingPropertyValue"
  }, description);
};
exports.ThreatMapping = ThreatMapping;
const SuppressAlertsByField = ({
  fields
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: fields,
  "data-test-subj": "alertSuppressionGroupByPropertyValue"
});
exports.SuppressAlertsByField = SuppressAlertsByField;
const SuppressAlertsDuration = ({
  duration
}) => {
  const durationDescription = duration ? `${duration.value}${duration.unit}` : descriptionStepI18n.ALERT_SUPPRESSION_PER_RULE_EXECUTION;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alertSuppressionDurationPropertyValue"
  }, durationDescription);
};
exports.SuppressAlertsDuration = SuppressAlertsDuration;
const MissingFieldsStrategy = ({
  missingFieldsStrategy
}) => {
  const missingFieldsDescription = missingFieldsStrategy === _rule_schema.AlertSuppressionMissingFieldsStrategyEnum.suppress ? descriptionStepI18n.ALERT_SUPPRESSION_SUPPRESS_ON_MISSING_FIELDS : descriptionStepI18n.ALERT_SUPPRESSION_DO_NOT_SUPPRESS_ON_MISSING_FIELDS;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alertSuppressionMissingFieldsPropertyValue"
  }, missingFieldsDescription);
};
exports.MissingFieldsStrategy = MissingFieldsStrategy;
const NewTermsFields = ({
  newTermsFields
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: newTermsFields,
  "data-test-subj": "newTermsFieldsPropertyValue"
});
exports.NewTermsFields = NewTermsFields;
const HistoryWindowSize = ({
  historyWindowStart
}) => {
  const size = historyWindowStart ? (0, _date_math.convertDateMathToDuration)(historyWindowStart) : _constants2.DEFAULT_HISTORY_WINDOW_SIZE;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `newTermsWindowSizePropertyValue-${historyWindowStart}`
  }, size);
};
exports.HistoryWindowSize = HistoryWindowSize;
// eslint-disable-next-line complexity
const prepareDefinitionSectionListItems = ({
  rule,
  isInteractive,
  savedQuery,
  isSuppressionEnabled
}) => {
  var _rule$filters;
  const definitionSectionListItems = [];
  if ('index' in rule && rule.index && rule.index.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "indexPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.INDEX_FIELD_LABEL,
        fieldName: "data_source"
      })),
      description: /*#__PURE__*/_react.default.createElement(Index, {
        index: rule.index
      })
    });
  }
  if ('data_view_id' in rule && rule.data_view_id) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "dataViewIdPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.DATA_VIEW_ID_FIELD_LABEL,
        fieldName: "data_source"
      })),
      description: /*#__PURE__*/_react.default.createElement(DataViewId, {
        dataViewId: rule.data_view_id
      })
    }, {
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "dataViewIndexPatternPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.DATA_VIEW_INDEX_PATTERN_FIELD_LABEL,
        fieldName: "data_source"
      })),
      description: /*#__PURE__*/_react.default.createElement(DataViewIndexPattern, {
        dataViewId: rule.data_view_id
      })
    });
  }
  if (savedQuery) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "savedQueryNamePropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: descriptionStepI18n.SAVED_QUERY_NAME_LABEL,
        fieldName: "kql_query"
      })),
      description: /*#__PURE__*/_react.default.createElement(SavedQueryName, {
        savedQueryName: savedQuery.attributes.title
      })
    }, {
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "savedQueryLanguagePropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.SAVED_QUERY_LANGUAGE_LABEL,
        fieldName: "kql_query"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "savedQueryLanguagePropertyValue"
      }, (0, _helpers.getQueryLanguageLabel)(savedQuery.attributes.query.language))
    });
    if (savedQuery.attributes.filters) {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "savedQueryFiltersPropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.SAVED_QUERY_FILTERS_LABEL,
          fieldName: "kql_query"
        })),
        description: /*#__PURE__*/_react.default.createElement(Filters, {
          filters: savedQuery.attributes.filters,
          "data-test-subj": "savedQueryFiltersPropertyValue",
          dataViewId: 'data_view_id' in rule ? rule.data_view_id : undefined,
          index: 'index' in rule ? rule.index : undefined
        })
      });
    }
    if (typeof savedQuery.attributes.query.query === 'string') {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "savedQueryContentPropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.SAVED_QUERY_LABEL,
          fieldName: "kql_query"
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: savedQuery.attributes.query.query,
          "data-test-subj": "savedQueryContentPropertyValue"
        })
      });
    }
  }
  if ('filters' in rule && (_rule$filters = rule.filters) !== null && _rule$filters !== void 0 && _rule$filters.length) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "filtersPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: descriptionStepI18n.FILTERS_LABEL,
        fieldName: "kql_query"
      })),
      description: /*#__PURE__*/_react.default.createElement(Filters, {
        filters: rule.filters,
        dataViewId: rule.data_view_id,
        index: rule.index,
        "data-test-subj": "filtersPropertyValue"
      })
    });
  }
  if ('query' in rule && rule.query) {
    if (rule.type === 'eql') {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "eqlQueryPropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.EQL_QUERY_LABEL,
          fieldName: "eql_query"
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: rule.query,
          "data-test-subj": "eqlQueryPropertyValue"
        })
      });
    } else if (rule.type === 'esql') {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "esqlQueryPropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.ESQL_QUERY_LABEL,
          fieldName: "esql_query"
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: rule.query,
          "data-test-subj": "esqlQueryPropertyValue"
        })
      });
    } else {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "customQueryPropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.QUERY_LABEL,
          fieldName: "kql_query"
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: rule.query,
          "data-test-subj": "customQueryPropertyValue"
        })
      }, {
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "customQueryLanguagePropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: i18n.QUERY_LANGUAGE_LABEL,
          fieldName: "kql_query"
        })),
        description: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "customQueryLanguagePropertyValue"
        }, (0, _helpers.getQueryLanguageLabel)(rule.language || ''))
      });
    }
  }
  if (rule.event_category_override) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsEventCategoryOverrideTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: _translations5.EQL_OPTIONS_EVENT_CATEGORY_FIELD_LABEL,
        fieldName: "eql_query"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsEventCategoryOverrideValue"
      }, rule.event_category_override)
    });
  }
  if (rule.tiebreaker_field) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsTiebreakerFieldTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: _translations5.EQL_OPTIONS_EVENT_TIEBREAKER_FIELD_LABEL,
        fieldName: "eql_query"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsEventTiebreakerFieldValue"
      }, rule.tiebreaker_field)
    });
  }
  if (rule.timestamp_field) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsTimestampFieldTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: _translations5.EQL_OPTIONS_EVENT_TIMESTAMP_FIELD_LABEL,
        fieldName: "eql_query"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsTimestampFieldValue"
      }, rule.timestamp_field)
    });
  }
  if (rule.type) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "type"
      }),
      description: /*#__PURE__*/_react.default.createElement(RuleType, {
        type: rule.type
      })
    });
  }
  if ('anomaly_threshold' in rule && rule.anomaly_threshold) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "anomalyThresholdPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "anomaly_threshold"
      })),
      description: /*#__PURE__*/_react.default.createElement(AnomalyThreshold, {
        anomalyThreshold: rule.anomaly_threshold
      })
    });
  }
  if ('machine_learning_job_id' in rule) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "mlJobPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "machine_learning_job_id"
      })),
      description: /*#__PURE__*/_react.default.createElement(MachineLearningJobList, {
        jobIds: rule.machine_learning_job_id,
        isInteractive: isInteractive
      })
    });
  }
  if (rule.related_integrations && rule.related_integrations.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "relatedIntegrationsPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "related_integrations"
      })),
      description: /*#__PURE__*/_react.default.createElement(_integrations_description.RelatedIntegrationsDescription, {
        relatedIntegrations: rule.related_integrations,
        dataTestSubj: "relatedIntegrationsPropertyValue"
      })
    });
  }
  if (rule.required_fields && rule.required_fields.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "requiredFieldsPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "required_fields"
      })),
      description: /*#__PURE__*/_react.default.createElement(RequiredFields, {
        requiredFields: rule.required_fields
      })
    });
  }
  definitionSectionListItems.push({
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "timelineTemplatePropertyTitle"
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      fieldName: "timeline_template"
    })),
    description: /*#__PURE__*/_react.default.createElement(TimelineTitle, {
      timelineTitle: rule.timeline_title || timelinesI18n.DEFAULT_TIMELINE_TITLE
    })
  });
  if ('threshold' in rule && rule.threshold) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "thresholdPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threshold"
      })),
      description: /*#__PURE__*/_react.default.createElement(Threshold, {
        threshold: rule.threshold
      })
    });
  }
  if ('threat_index' in rule && rule.threat_index) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatIndexPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat_index"
      })),
      description: /*#__PURE__*/_react.default.createElement(ThreatIndex, {
        threatIndex: rule.threat_index
      })
    });
  }
  if ('threat_filters' in rule && rule.threat_filters && rule.threat_filters.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatFiltersPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.THREAT_FILTERS_FIELD_LABEL,
        fieldName: "threat_query"
      })),
      description: /*#__PURE__*/_react.default.createElement(Filters, {
        filters: rule.threat_filters,
        dataViewId: rule.data_view_id,
        index: rule.index,
        "data-test-subj": "threatFiltersPropertyValue"
      })
    });
  }
  if ('threat_query' in rule && rule.threat_query) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatQueryPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: descriptionStepI18n.THREAT_QUERY_LABEL,
        fieldName: "threat_query"
      })),
      description: /*#__PURE__*/_react.default.createElement(Query, {
        query: rule.threat_query,
        "data-test-subj": "threatQueryPropertyValue"
      })
    });
  }
  if ('threat_language' in rule && rule.threat_language) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatQueryLanguagePropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.THREAT_QUERY_LANGUAGE_LABEL,
        fieldName: "threat_query"
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatQueryLanguagePropertyValue"
      }, (0, _helpers.getQueryLanguageLabel)(rule.threat_language))
    });
  }
  if ('threat_mapping' in rule && rule.threat_mapping) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatMappingPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat_mapping"
      })),
      description: /*#__PURE__*/_react.default.createElement(ThreatMapping, {
        threatMapping: rule.threat_mapping
      })
    });
  }
  if ('new_terms_fields' in rule && rule.new_terms_fields && rule.new_terms_fields.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "newTermsFieldsPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "new_terms_fields"
      })),
      description: /*#__PURE__*/_react.default.createElement(NewTermsFields, {
        newTermsFields: rule.new_terms_fields
      })
    });
  }
  if ('history_window_start' in rule) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "newTermsWindowSizePropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "history_window_start"
      })),
      description: /*#__PURE__*/_react.default.createElement(HistoryWindowSize, {
        historyWindowStart: rule.history_window_start
      })
    });
  }
  if (isSuppressionEnabled && 'alert_suppression' in rule && rule.alert_suppression) {
    if ('group_by' in rule.alert_suppression) {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "alertSuppressionGroupByPropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
          label: i18n.SUPPRESS_ALERTS_BY_FIELD_LABEL,
          ruleType: rule.type
        })),
        description: /*#__PURE__*/_react.default.createElement(SuppressAlertsByField, {
          fields: rule.alert_suppression.group_by
        })
      });
    }
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "alertSuppressionDurationPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: i18n.SUPPRESS_ALERTS_DURATION_FIELD_LABEL,
        ruleType: rule.type
      })),
      description: /*#__PURE__*/_react.default.createElement(SuppressAlertsDuration, {
        duration: rule.alert_suppression.duration
      })
    });
    if ('missing_fields_strategy' in rule.alert_suppression) {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "alertSuppressionMissingFieldPropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
          label: i18n.SUPPRESSION_FIELD_MISSING_FIELD_LABEL,
          ruleType: rule.type
        })),
        description: /*#__PURE__*/_react.default.createElement(MissingFieldsStrategy, {
          missingFieldsStrategy: rule.alert_suppression.missing_fields_strategy
        })
      });
    }
  }
  return definitionSectionListItems;
};
const RuleDefinitionSection = ({
  rule,
  isInteractive = false,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  dataTestSubj,
  ...descriptionListProps
}) => {
  var _descriptionListProps, _descriptionListProps2;
  const {
    savedQuery
  } = (0, _use_get_saved_query.useGetSavedQuery)({
    savedQueryId: rule.type === 'saved_query' ? rule.saved_id : '',
    ruleType: rule.type
  });
  const {
    isSuppressionEnabled
  } = (0, _use_alert_suppression.useAlertSuppression)(rule.type);
  const definitionSectionListItems = prepareDefinitionSectionListItems({
    rule,
    isInteractive,
    savedQuery,
    isSuppressionEnabled
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: definitionSectionListItems,
    columnWidths: columnWidths,
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, descriptionListProps)));
};
exports.RuleDefinitionSection = RuleDefinitionSection;