"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueWithSpaceWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _use_value_with_space_warning = require("./use_value_with_space_warning");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  display: inline;
  margin-left: ${({
  theme
}) => `${theme.eui.euiSizeXS}`};
`;
const ValueWithSpaceWarning = ({
  value,
  tooltipIconType = 'info',
  tooltipIconText
}) => {
  const {
    showSpaceWarningIcon,
    warningText
  } = (0, _use_value_with_space_warning.useValueWithSpaceWarning)({
    value,
    tooltipIconText
  });
  if (!showSpaceWarningIcon || !value) return null;
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: warningText,
    position: "top",
    iconProps: {
      'data-test-subj': 'value_with_space_warning_tooltip'
    },
    type: tooltipIconType,
    color: "warning"
  }));
};
exports.ValueWithSpaceWarning = ValueWithSpaceWarning;