"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addRelatedIntegrationRow = addRelatedIntegrationRow;
exports.removeLastRelatedIntegrationRow = removeLastRelatedIntegrationRow;
exports.setVersion = setVersion;
exports.waitForIntegrationsToBeLoaded = waitForIntegrationsToBeLoaded;
var _react = require("@testing-library/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

const REMOVE_INTEGRATION_ROW_BUTTON_TEST_ID = 'relatedIntegrationRemove';
function waitForIntegrationsToBeLoaded() {
  return (0, _react.waitForElementToBeRemoved)(_react.screen.queryAllByRole('progressbar'));
}
function addRelatedIntegrationRow() {
  return (0, _react.act)(async () => {
    _react.fireEvent.click(_react.screen.getByText('Add integration'));
  });
}
function removeLastRelatedIntegrationRow() {
  return (0, _react.act)(async () => {
    const lastRemoveButton = _react.screen.getAllByTestId(REMOVE_INTEGRATION_ROW_BUTTON_TEST_ID).at(-1);
    if (!lastRemoveButton) {
      throw new Error(`There are no "${REMOVE_INTEGRATION_ROW_BUTTON_TEST_ID}" found`);
    }
    _react.fireEvent.click(lastRemoveButton);
  });
}
function setVersion({
  input,
  value
}) {
  return (0, _react.act)(async () => {
    _react.fireEvent.input(input, {
      target: {
        value
      }
    });
  });
}