"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsOverflow = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * It checks if the element that receives the returned Ref has oveflow the max height.
 */
const useIsOverflow = dependency => {
  const [isOverflow, setIsOverflow] = (0, _react.useState)(null);
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    var _ref$current;
    if (((_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.clientHeight) != null) {
      var _ref$current$scrollHe, _ref$current2, _ref$current$clientHe, _ref$current3, _ref$current$scrollHe2, _ref$current4, _ref$current$clientHe2, _ref$current5;
      if (((_ref$current$scrollHe = ref === null || ref === void 0 ? void 0 : (_ref$current2 = ref.current) === null || _ref$current2 === void 0 ? void 0 : _ref$current2.scrollHeight) !== null && _ref$current$scrollHe !== void 0 ? _ref$current$scrollHe : 0) > ((_ref$current$clientHe = ref === null || ref === void 0 ? void 0 : (_ref$current3 = ref.current) === null || _ref$current3 === void 0 ? void 0 : _ref$current3.clientHeight) !== null && _ref$current$clientHe !== void 0 ? _ref$current$clientHe : 0)) {
        setIsOverflow(true);
      }
      if (((_ref$current$scrollHe2 = (_ref$current4 = ref.current) === null || _ref$current4 === void 0 ? void 0 : _ref$current4.scrollHeight) !== null && _ref$current$scrollHe2 !== void 0 ? _ref$current$scrollHe2 : 0) <= ((_ref$current$clientHe2 = ref === null || ref === void 0 ? void 0 : (_ref$current5 = ref.current) === null || _ref$current5 === void 0 ? void 0 : _ref$current5.clientHeight) !== null && _ref$current$clientHe2 !== void 0 ? _ref$current$clientHe2 : 0)) {
        setIsOverflow(false);
      }
    }
  }, [ref, dependency]);
  return [isOverflow, ref];
};
exports.useIsOverflow = useIsOverflow;