"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SCHEDULE_TIME_UNITS_SECOND = exports.SCHEDULE_TIME_UNITS_MINUTE = exports.SCHEDULE_TIME_UNITS_HOUR = exports.SCHEDULE_TIME_UNITS_DAY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULE_TIME_UNITS_SECOND = (timeValue = '0') => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.timeUnits.secondLabel', {
  defaultMessage: '{timeValue, plural, one {second} other {seconds}}',
  values: {
    timeValue
  }
});
exports.SCHEDULE_TIME_UNITS_SECOND = SCHEDULE_TIME_UNITS_SECOND;
const SCHEDULE_TIME_UNITS_MINUTE = (timeValue = '0') => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.timeUnits.minuteLabel', {
  defaultMessage: '{timeValue, plural, one {minute} other {minutes}}',
  values: {
    timeValue
  }
});
exports.SCHEDULE_TIME_UNITS_MINUTE = SCHEDULE_TIME_UNITS_MINUTE;
const SCHEDULE_TIME_UNITS_HOUR = (timeValue = '0') => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.timeUnits.hourLabel', {
  defaultMessage: '{timeValue, plural, one {hour} other {hours}}',
  values: {
    timeValue
  }
});
exports.SCHEDULE_TIME_UNITS_HOUR = SCHEDULE_TIME_UNITS_HOUR;
const SCHEDULE_TIME_UNITS_DAY = (timeValue = '0') => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.timeUnits.dayLabel', {
  defaultMessage: '{timeValue, plural, one {day} other {days}}',
  values: {
    timeValue
  }
});
exports.SCHEDULE_TIME_UNITS_DAY = SCHEDULE_TIME_UNITS_DAY;