"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunScriptRouteRequestBody = exports.RunScriptActionResponse = exports.RunScriptActionRequestBody = exports.RawScriptParameters = exports.HostPathScriptParameters = exports.CloudFileScriptParameters = void 0;
var _zod = require("@kbn/zod");
var _common = require("../../../model/schema/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: RunScript Action Schema
 *   version: 2023-10-31
 */

const RawScriptParameters = exports.RawScriptParameters = _zod.z.object({
  /**
   * Raw script content.
   */
  raw: _zod.z.string().min(1),
  /**
   * Command line arguments.
   */
  commandLine: _zod.z.string().min(1).optional(),
  /**
   * Timeout in seconds.
   */
  timeout: _zod.z.number().int().min(1).optional()
});
const HostPathScriptParameters = exports.HostPathScriptParameters = _zod.z.object({
  /**
   * Absolute or relative path of script on host machine.
   */
  hostPath: _zod.z.string().min(1),
  /**
   * Command line arguments.
   */
  commandLine: _zod.z.string().min(1).optional(),
  /**
   * Timeout in seconds.
   */
  timeout: _zod.z.number().int().min(1).optional()
});
const CloudFileScriptParameters = exports.CloudFileScriptParameters = _zod.z.object({
  /**
   * Script name in cloud storage.
   */
  cloudFile: _zod.z.string().min(1),
  /**
   * Command line arguments.
   */
  commandLine: _zod.z.string().min(1).optional(),
  /**
   * Timeout in seconds.
   */
  timeout: _zod.z.number().int().min(1).optional()
});
const RunScriptRouteRequestBody = exports.RunScriptRouteRequestBody = _zod.z.object({
  /**
   * Exactly one of 'Raw', 'HostPath', or 'CloudFile' must be provided. CommandLine and Timeout are optional for all.
   */
  parameters: _zod.z.union([RawScriptParameters, HostPathScriptParameters, CloudFileScriptParameters])
});
const RunScriptActionRequestBody = exports.RunScriptActionRequestBody = RunScriptRouteRequestBody;
const RunScriptActionResponse = exports.RunScriptActionResponse = _common.SuccessResponse;