"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleTableDisplay = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _model = require("../../../common/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleTableDisplay = ({
  role,
  navigateToApp
}) => {
  let content;
  let path;
  if (typeof role === 'string') {
    content = /*#__PURE__*/_react.default.createElement("div", null, role);
    path = `security/roles/edit/${encodeURIComponent(role)}`;
  } else if ((0, _model.isRoleDeprecated)(role)) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: (0, _model.getExtendedRoleDeprecationNotice)(role),
      "data-test-subj": "roleDeprecationTooltip"
    }, /*#__PURE__*/_react.default.createElement("div", {
      tabIndex: 0
    }, role.name, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "warning",
      size: "s",
      className: 'eui-alignTop'
    })));
    path = `security/roles/edit/${encodeURIComponent(role.name)}`;
  } else {
    content = /*#__PURE__*/_react.default.createElement("div", null, role.name);
    path = `security/roles/edit/${encodeURIComponent(role.name)}`;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => navigateToApp('management', {
      path
    })
  }, content);
};
exports.RoleTableDisplay = RoleTableDisplay;