"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymsSetEmptyRuleTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../common/doc_links");
var _empty_rules_cards = require("./empty_rules_cards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SynonymsSetEmptyRuleTable = ({
  onCreateRule
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRuleTable.title', {
    defaultMessage: 'Select a rule type'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchSynonymsSynonymsSetEmptyRuleTableViewDocumentationLink",
    href: _doc_links.docLinks.synonymsApi
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRuleTable.viewDocumentation', {
    defaultMessage: 'View documentation'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_empty_rules_cards.SynonymsSetEmptyRulesCards, {
    onCreateRule: onCreateRule
  })));
};
exports.SynonymsSetEmptyRuleTable = SynonymsSetEmptyRuleTable;