"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _field_error_utils = require("../../../utils/field_error_utils");
var _use_kibana = require("../../../hooks/use_kibana");
var _styles = require("../styles");
var _query_rule_metadata_editor = require("./query_rule_metadata_editor");
var _use_query_rule_flyout_state = require("./use_query_rule_flyout_state");
var _query_rule_flyout_header = require("./query_rule_flyout_header");
var _rule_type_selector = require("./document_selector/rule_type_selector");
var _pin_exclude_document_button = require("./pin_exclude_document_button");
var _metadata_type_selector = require("./metadata_type_selector");
var _draggable_list = require("./document_selector/draggable_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRuleFlyout = ({
  rules,
  onClose,
  onSave,
  ruleId,
  rulesetId,
  setIsFormDirty,
  createMode = false
}) => {
  const {
    actionFields,
    actionIdsFields,
    appendAction: appendNewAction,
    control,
    criteria,
    criteriaCount,
    documentCount,
    dragEndHandle,
    formState,
    handleAddCriteria,
    handleSave,
    indexNames,
    isFlyoutDirty,
    isIdRule,
    onDeleteDocument,
    onIdSelectorChange,
    onIndexSelectorChange,
    pinType,
    remove,
    setCriteriaCalloutActive,
    shouldShowCriteriaCallout,
    shouldShowMetadataEditor,
    update
  } = (0, _use_query_rule_flyout_state.useQueryRuleFlyoutState)({
    createMode,
    rulesetId,
    ruleId,
    rules,
    setIsFormDirty,
    onSave
  });
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dndBackgroundColor = (0, _react2.css)`
    background-color: ${euiTheme.colors.backgroundBaseFormsPrepend};
  `;
  const pinExcludeText = pinType === 'pinned' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionType.pinned.description",
    defaultMessage: "Pin documents to the top of the search results."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionType.exclude.description",
    defaultMessage: "Exclude documents from the search results."
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    ownFocus: false,
    size: "l",
    "data-test-subj": "searchQueryRulesQueryRuleFlyout",
    "aria-labelledby": "flyoutTitle",
    css: (0, _react2.css)({
      overflowY: 'hidden'
    })
  }, /*#__PURE__*/_react.default.createElement(_query_rule_flyout_header.QueryRuleFlyoutHeader, {
    ruleId: ruleId,
    createMode: createMode
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: _styles.QueryRuleFlyoutBody
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: _styles.QueryRuleFlyoutPanel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    borderRadius: "none",
    className: "eui-yScroll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionTypeHeading",
    defaultMessage: "I want to"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "type",
    render: ({
      field: {
        value,
        onChange
      }
    }) => /*#__PURE__*/_react.default.createElement(_rule_type_selector.QueryRuleTypeSelector, {
      onChange: onChange,
      selectedId: value
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, pinExcludeText)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.documentCount",
    defaultMessage: "{documentCount, plural, one {# document} other {# documents}}",
    values: {
      documentCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.findDocuments",
    defaultMessage: "Find your documents IDs into "
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutLink",
    external: true,
    href: "#" // Removing href hides the external link icon
    ,
    onClick: e => {
      e.preventDefault();
      application.navigateToApp(_deeplinksAnalytics.DISCOVER_APP_ID, {
        openInNewTab: true
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.DiscoverDocumentsLink",
    defaultMessage: "Discover"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isIdRule && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Document action using 'ids' are unsupported",
    color: "warning",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRuleset.queryRuleFlyout.idsActionDeprecation",
    defaultMessage: "Query rules pinning/excluding documents using ids only are not supported in the UIs. Please convert them to pinning by docs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: dndBackgroundColor
  }, /*#__PURE__*/_react.default.createElement(_draggable_list.DraggableList, {
    onIndexSelectorChange: onIndexSelectorChange,
    onIdSelectorChange: onIdSelectorChange,
    actionFields: actionFields,
    actionIdsFields: actionIdsFields,
    isIdRule: isIdRule,
    pinType: pinType,
    indexNames: indexNames,
    dragEndHandle: dragEndHandle,
    onDeleteDocument: onDeleteDocument,
    errors: formState.errors
  })), pinType === 'pinned' && documentCount !== 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "transitionTopIn",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.organicResultsCallout",
      defaultMessage: "All other organic results will be displayed below"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_pin_exclude_document_button.ExcludePinDocumentButton, {
    documentCount: documentCount,
    addNewAction: appendNewAction,
    pinType: pinType
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: _styles.QueryRuleFlyoutPanel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    borderRadius: "none",
    className: "eui-yScroll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.criteriaHeading",
    defaultMessage: "Criteria"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "isAlways",
    render: ({
      field: {
        value,
        onChange
      }
    }) => /*#__PURE__*/_react.default.createElement(_metadata_type_selector.MetadataTypeSelector, {
      isAlways: value,
      onChange: onChange
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.criteria.custom.description",
    defaultMessage: "Define the conditions that trigger this rule."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), shouldShowCriteriaCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    size: "s",
    onDismiss: () => {
      setCriteriaCalloutActive(false);
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.allCriteriaCallout",
      defaultMessage: "All criteria must be met for the rule to be applied"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), shouldShowMetadataEditor && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, criteria.length ? criteria.map((field, index) => {
    var _formState$errors, _formState$errors$cri;
    const error = (_formState$errors = formState.errors) === null || _formState$errors === void 0 ? void 0 : (_formState$errors$cri = _formState$errors.criteria) === null || _formState$errors$cri === void 0 ? void 0 : _formState$errors$cri[index];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: field.id
    }, /*#__PURE__*/_react.default.createElement(_query_rule_metadata_editor.QueryRuleMetadataEditor, {
      criteria: field,
      key: field.id,
      onChange: newCriteria => {
        update(index, newCriteria);
      },
      onRemove: () => {
        remove(index);
      },
      error: (0, _field_error_utils.isQueryRuleFieldError)(error) ? error : undefined
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    size: "s",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.criteriaRequiredCallout",
      defaultMessage: "At least one criteria is required."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchQueryRulesQueryRuleMetadataEditorAddCriteriaButton",
    onClick: handleAddCriteria,
    iconType: "plusInCircle",
    iconSide: "left",
    size: "s",
    color: criteriaCount === 0 ? 'primary' : 'text',
    fill: criteriaCount === 0
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addCriteriaButton",
    defaultMessage: "AND"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutCancelButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutUpdateButton",
    fill: true,
    onClick: handleSave,
    disabled:
    // Id rule is not supported in the UI. We still allow saving it.
    // To make it properly, we need to reimplement the action logic in RHF
    !isIdRule && !isFlyoutDirty || !formState.isValid || formState.isSubmitting || formState.isValidating
  }, createMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.createButton",
    defaultMessage: "Create rule"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.updateButton",
    defaultMessage: "Update rule"
  }))))));
};
exports.QueryRuleFlyout = QueryRuleFlyout;