"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _playground_header_docs = require("./playground_header_docs");
var _toolbar = require("./toolbar");
var _types = require("../types");
var _use_search_playground_feature_flag = require("../hooks/use_search_playground_feature_flag");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = ({
  pageMode,
  viewMode,
  onModeChange,
  showDocs = false,
  isActionsDisabled = false,
  onSelectPageModeChange,
  playgroundName,
  hasChanges
}) => {
  const isSearchModeEnabled = (0, _use_search_playground_feature_flag.useSearchPlaygroundFeatureFlag)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const options = [{
    id: _types.PlaygroundViewMode.preview,
    label: pageMode === _types.PlaygroundPageMode.chat ? _i18n.i18n.translate('xpack.searchPlayground.header.view.chat', {
      defaultMessage: 'Chat'
    }) : _i18n.i18n.translate('xpack.searchPlayground.header.view.preview', {
      defaultMessage: 'Preview'
    }),
    'data-test-subj': 'chatMode'
  }, {
    id: _types.PlaygroundViewMode.query,
    label: _i18n.i18n.translate('xpack.searchPlayground.header.view.query', {
      defaultMessage: 'Query'
    }),
    'data-test-subj': 'queryMode'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    css: {
      '.euiPageHeaderContent > .euiFlexGroup': {
        flexWrap: 'wrap'
      },
      backgroundColor: euiTheme.colors.emptyShade
    },
    paddingSize: "s",
    "data-test-subj": "chat-playground-home-page"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, playgroundName === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      whiteSpace: 'nowrap'
    },
    "data-test-subj": "chat-playground-home-page-title",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.pageTitle",
    defaultMessage: "Playground"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      whiteSpace: 'nowrap'
    },
    "data-test-subj": "playgroundName",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, playgroundName)), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "page-mode-select",
    options: [{
      value: _types.PlaygroundPageMode.Chat,
      text: 'Chat'
    }, {
      value: _types.PlaygroundPageMode.Search,
      text: 'Search'
    }],
    value: pageMode,
    onChange: e => onSelectPageModeChange(e.target.value)
  }), isSearchModeEnabled && playgroundName !== undefined && hasChanges ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.header.unsavedChangesBadge",
    defaultMessage: "Unsaved changes"
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "viewMode",
    options: options,
    idSelected: viewMode,
    onChange: id => onModeChange(id),
    buttonSize: "compressed",
    isDisabled: isActionsDisabled,
    "data-test-subj": "viewModeSelector"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, showDocs && /*#__PURE__*/_react.default.createElement(_playground_header_docs.PlaygroundHeaderDocs, null), /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, {
    selectedPageMode: pageMode
  }))));
};
exports.Header = Header;