"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorMessage = getErrorMessage;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getErrorMessage(e) {
  if (e instanceof Error) {
    if (e.cause instanceof Error) {
      return _i18n.i18n.translate('xpack.searchPlayground.errorWithCauseMessage', {
        defaultMessage: '{message}. Caused by: {causeMessage}',
        values: {
          message: e.message,
          causeMessage: e.cause.message
        }
      });
    }
    return e.message;
  } else if (typeof e === 'string') {
    return e;
  } else if (typeof e === 'object' && e !== null && 'message' in e) {
    return e.message;
  } else if (typeof e === 'object' && e !== null && 'toString' in e) {
    return e.toString();
  } else {
    return String(e);
  }
}