"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetch = fetch;
var _axios = _interopRequireDefault(require("axios"));
var _crypto = require("crypto");
var _promises = require("fs/promises");
var _fs = require("fs");
var _path = require("path");
var _promises2 = require("stream/promises");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Download a url and calculate it's checksum
 */
async function fetch(url, path, logger) {
  logger === null || logger === void 0 ? void 0 : logger.info(`Downloading ${url} to ${path}`);
  const hash = (0, _crypto.createHash)('sha256');
  await (0, _promises.mkdir)((0, _path.dirname)(path), {
    recursive: true
  });
  const handle = await (0, _promises.open)(path, 'w');
  try {
    const response = await _axios.default.request({
      url,
      method: 'GET',
      responseType: 'stream'
    });
    response.data.on('data', chunk => {
      (0, _fs.writeSync)(handle.fd, chunk);
      hash.update(chunk);
    });
    await (0, _promises2.finished)(response.data);
    logger === null || logger === void 0 ? void 0 : logger.info(`Downloaded ${url}`);
  } catch (error) {
    logger === null || logger === void 0 ? void 0 : logger.error(error);
    throw new Error(`Unable to download ${url}: ${error}`);
  } finally {
    await handle.close();
  }
  return hash.digest('hex');
}