"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloudSetupTrustUrl = exports.cloudCreateApiKey = exports.apiKeys = void 0;
exports.init = init;
exports.transportPortUrl = exports.skippingDisconnectedClustersUrl = exports.remoteClustersUrl = exports.proxySettingsUrl = exports.proxyModeUrl = exports.onPremSecurityCert = exports.onPremSecurityApiKey = exports.onPremPrerequisitesCert = exports.onPremPrerequisitesApiKey = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let skippingDisconnectedClustersUrl = exports.skippingDisconnectedClustersUrl = void 0;
let remoteClustersUrl = exports.remoteClustersUrl = void 0;
let transportPortUrl = exports.transportPortUrl = void 0;
let proxyModeUrl = exports.proxyModeUrl = void 0;
let proxySettingsUrl = exports.proxySettingsUrl = void 0;
let cloudSetupTrustUrl = exports.cloudSetupTrustUrl = void 0;
let apiKeys = exports.apiKeys = void 0;
let cloudCreateApiKey = exports.cloudCreateApiKey = void 0;
let onPremPrerequisitesApiKey = exports.onPremPrerequisitesApiKey = void 0;
let onPremSecurityApiKey = exports.onPremSecurityApiKey = void 0;
let onPremPrerequisitesCert = exports.onPremPrerequisitesCert = void 0;
let onPremSecurityCert = exports.onPremSecurityCert = void 0;
function init({
  links
}) {
  exports.skippingDisconnectedClustersUrl = skippingDisconnectedClustersUrl = links.ccs.skippingDisconnectedClusters;
  exports.remoteClustersUrl = remoteClustersUrl = links.elasticsearch.remoteClusters;
  exports.transportPortUrl = transportPortUrl = links.elasticsearch.transportSettings;
  exports.proxyModeUrl = proxyModeUrl = links.elasticsearch.remoteClustersProxy;
  exports.proxySettingsUrl = proxySettingsUrl = links.elasticsearch.remoteClusersProxySettings;
  exports.cloudSetupTrustUrl = cloudSetupTrustUrl = links.elasticsearch.remoteClustersCloudSetupTrust;
  exports.apiKeys = apiKeys = links.management.apiKeys;
  exports.cloudCreateApiKey = cloudCreateApiKey = links.elasticsearch.remoteClustersCreateCloudClusterApiKey;
  exports.onPremPrerequisitesApiKey = onPremPrerequisitesApiKey = links.elasticsearch.remoteClustersOnPremPrerequisitesApiKey;
  exports.onPremSecurityApiKey = onPremSecurityApiKey = links.elasticsearch.remoteClustersOnPremSecurityApiKey;
  exports.onPremPrerequisitesCert = onPremPrerequisitesCert = links.elasticsearch.remoteClustersOnPremPrerequisitesCert;
  exports.onPremSecurityCert = onPremSecurityCert = links.elasticsearch.remoteClustersOnPremSecurityCert;
}