"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elasticClassicPalette = void 0;
var _i18n = require("@kbn/i18n");
var _categorical_palette = require("../../../classes/categorical_palette");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const elasticClassicPalette = exports.elasticClassicPalette = new _categorical_palette.KbnCategoricalPalette({
  id: _constants.KbnPalette.ElasticClassic,
  name: _i18n.i18n.translate('palettes.classic.name', {
    defaultMessage: 'Elastic classic'
  }),
  colors: ['#20377d', '#7de2d1', '#ff957d', '#f04e98', '#0077cc', '#fec514']
});