"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogsDataView = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogsDataView = payload => {
  const dataViews = (0, _kibana.useKibana)().services.data.dataViews;
  return (0, _reactQuery.useQuery)(['logsDataView'], async () => {
    let dataView;
    try {
      const data = await dataViews.find('logs-osquery_manager.result*', 1);
      if (data.length) {
        dataView = data[0];
      } else {
        throw new Error('No data view found');
      }
      // eslint-disable-next-line no-empty
    } catch (e) {}
    if (!dataView && dataViews.getCanSaveSync()) {
      try {
        dataView = await dataViews.createAndSave({
          title: 'logs-osquery_manager.result*',
          timeFieldName: '@timestamp'
        });
        // eslint-disable-next-line no-empty
      } catch (e) {}
    }
    if (!dataView && !(payload !== null && payload !== void 0 && payload.checkOnly)) {
      try {
        dataView = await dataViews.create({
          title: 'logs-osquery_manager.result*',
          timeFieldName: '@timestamp'
        });
        // eslint-disable-next-line no-empty
      } catch (e) {}
    }
    return dataView;
  }, {
    enabled: !(payload !== null && payload !== void 0 && payload.skip),
    retry: 1
  });
};
exports.useLogsDataView = useLogsDataView;