"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConversation = exports.toEs = exports.fromEs = exports.createRequestToEs = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fromEs = document => {
  if (!document._source) {
    throw new Error('No source found on get conversation response');
  }
  return {
    id: document._id,
    agentId: (0, _onechatCommon.toSerializedAgentIdentifier)({
      agentId: document._source.agent_id,
      providerId: document._source.agent_provider_id
    }),
    user: {
      id: document._source.user_id,
      username: document._source.user_name
    },
    title: document._source.title,
    createdAt: document._source.created_at,
    updatedAt: document._source.updated_at,
    rounds: document._source.rounds
  };
};
exports.fromEs = fromEs;
const toEs = conversation => {
  const structuredAgentId = (0, _onechatCommon.toStructuredAgentIdentifier)(conversation.agentId);
  return {
    agent_id: structuredAgentId.agentId,
    agent_provider_id: structuredAgentId.providerId,
    user_id: conversation.user.id,
    user_name: conversation.user.username,
    title: conversation.title,
    created_at: conversation.createdAt,
    updated_at: conversation.updatedAt,
    rounds: conversation.rounds
  };
};
exports.toEs = toEs;
const updateConversation = ({
  conversation,
  update,
  updateDate
}) => {
  const updated = {
    ...conversation,
    ...update,
    updatedAt: updateDate.toISOString()
  };
  return updated;
};
exports.updateConversation = updateConversation;
const createRequestToEs = ({
  conversation,
  currentUser,
  creationDate
}) => {
  const structuredAgentId = (0, _onechatCommon.toStructuredAgentIdentifier)(conversation.agentId);
  return {
    agent_id: structuredAgentId.agentId,
    agent_provider_id: structuredAgentId.providerId,
    user_id: currentUser.id,
    user_name: currentUser.username,
    title: conversation.title,
    created_at: creationDate.toISOString(),
    updated_at: creationDate.toISOString(),
    rounds: conversation.rounds
  };
};
exports.createRequestToEs = createRequestToEs;