"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lastReflectionResult = exports.isSearchResult = exports.isResearchGoalResult = exports.isReflectionResult = exports.firstResearchGoalResult = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isResearchGoalResult = item => {
  return 'researchGoal' in item && 'reasoning' in item;
};
exports.isResearchGoalResult = isResearchGoalResult;
const isReflectionResult = item => {
  return 'isSufficient' in item;
};
exports.isReflectionResult = isReflectionResult;
const isSearchResult = item => {
  return 'researchGoal' in item && 'output' in item;
};
exports.isSearchResult = isSearchResult;
const lastReflectionResult = backlog => {
  for (let i = backlog.length - 1; i >= 0; i--) {
    const current = backlog[i];
    if (isReflectionResult(current)) {
      return current;
    }
  }
  throw new Error('No reflection result found');
};
exports.lastReflectionResult = lastReflectionResult;
const firstResearchGoalResult = backlog => {
  for (let i = 0; i < backlog.length; i++) {
    const current = backlog[i];
    if (isResearchGoalResult(current)) {
      return current;
    }
  }
  throw new Error('No research goal result found');
};
exports.firstResearchGoalResult = firstResearchGoalResult;