"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimeSection = UptimeSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _formatters = require("@elastic/charts/dist/utils/data/formatters");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = require("styled-components");
var _public = require("@kbn/observability-shared-plugin/public");
var _section_container = require("../section_container");
var _data_handler = require("../../../../../context/has_data_context/data_handler");
var _use_has_data = require("../../../../../hooks/use_has_data");
var _use_date_picker_context = require("../../../../../hooks/use_date_picker_context");
var _chart_container = require("../../chart_container/chart_container");
var _styled_stat = require("../../styled_stat/styled_stat");
var _on_brush_end = require("../../../helpers/on_brush_end");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UptimeSection({
  bucketSize
}) {
  var _hasDataMap$uptime;
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  const chartThemes = (0, _public.useChartThemes)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    forceUpdate,
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd,
    lastUpdated
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const timeZone = (0, _public.useTimeZone)();
  const {
    data,
    status
  } = (0, _public.useFetcher)(() => {
    if (bucketSize && absoluteStart && absoluteEnd) {
      var _getDataHandler;
      return (_getDataHandler = (0, _data_handler.getDataHandler)('uptime')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.fetchData({
        absoluteTime: {
          start: absoluteStart,
          end: absoluteEnd
        },
        relativeTime: {
          start: relativeStart,
          end: relativeEnd
        },
        timeZone,
        ...bucketSize
      });
    }
  },
  // `forceUpdate` and `lastUpdated` should trigger a reload

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [bucketSize, relativeStart, relativeEnd, absoluteStart, absoluteEnd, forceUpdate, lastUpdated, timeZone]);
  if (!((_hasDataMap$uptime = hasDataMap.uptime) !== null && _hasDataMap$uptime !== void 0 && _hasDataMap$uptime.hasData)) {
    return null;
  }
  const min = _moment.default.utc(absoluteStart).valueOf();
  const max = _moment.default.utc(absoluteEnd).valueOf();
  const formatter = bucketSize !== null && bucketSize !== void 0 && bucketSize.dateFormat ? (0, _formatters.timeFormatter)(bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) : (0, _charts.niceTimeFormatter)([min, max]);
  const isLoading = status === _public.FETCH_STATUS.LOADING;
  const {
    appLink,
    stats,
    series
  } = data || {};
  const downColor = theme.eui.euiColorVis2;
  const upColor = theme.eui.euiColorMediumShade;
  return /*#__PURE__*/_react.default.createElement(_section_container.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.uptime.title', {
      defaultMessage: 'Monitors'
    }),
    appLink: {
      href: appLink,
      label: _i18n.i18n.translate('xpack.observability.overview.uptime.appLink', {
        defaultMessage: 'Show monitors'
      })
    },
    hasError: status === _public.FETCH_STATUS.FAILURE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    title: (0, _numeral.default)(stats === null || stats === void 0 ? void 0 : stats.monitors.value).format('0a'),
    description: _i18n.i18n.translate('xpack.observability.overview.uptime.monitors', {
      defaultMessage: 'Monitors'
    }),
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    title: (0, _numeral.default)(stats === null || stats === void 0 ? void 0 : stats.up.value).format('0a'),
    description: _i18n.i18n.translate('xpack.observability.overview.uptime.up', {
      defaultMessage: 'Up'
    }),
    isLoading: isLoading,
    color: upColor
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    title: (0, _numeral.default)(stats === null || stats === void 0 ? void 0 : stats.down.value).format('0a'),
    description: _i18n.i18n.translate('xpack.observability.overview.uptime.down', {
      defaultMessage: 'Down'
    }),
    isLoading: isLoading,
    color: downColor
  }))), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    isInitialLoad: isLoading && !data
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    onBrushEnd: event => (0, _on_brush_end.onBrushEnd)({
      x: event.x,
      history
    })
  }, chartThemes, {
    showLegend: false,
    legendPosition: _charts.Position.Right,
    xDomain: {
      min,
      max
    },
    locale: _i18n.i18n.getLocale()
  })), /*#__PURE__*/_react.default.createElement(UptimeBarSeries, {
    id: "down",
    label: _i18n.i18n.translate('xpack.observability.overview.uptime.chart.down', {
      defaultMessage: 'Down'
    }),
    series: series === null || series === void 0 ? void 0 : series.down,
    tickFormatter: formatter,
    color: downColor
  }), /*#__PURE__*/_react.default.createElement(UptimeBarSeries, {
    id: "up",
    label: _i18n.i18n.translate('xpack.observability.overview.uptime.chart.up', {
      defaultMessage: 'Up'
    }),
    series: series === null || series === void 0 ? void 0 : series.up,
    tickFormatter: formatter,
    color: upColor
  })));
}
function UptimeBarSeries({
  id,
  label,
  series,
  color,
  tickFormatter
}) {
  if (!series) {
    return null;
  }
  const chartData = series.coordinates.map(coordinate => ({
    ...coordinate,
    g: label
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: id,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    color: color,
    stackAccessors: ['x'],
    splitSeriesAccessors: ['g'],
    data: chartData
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: false,
    showOverlappingLabels: false,
    tickFormat: tickFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    gridLine: {
      visible: true
    },
    position: _charts.Position.Left,
    tickFormat: x => (0, _numeral.default)(x).format('0a')
  }));
}