"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyContainer = exports.ChartContainer = void 0;
exports.ErrorState = ErrorState;
exports.LoadingState = LoadingState;
exports.NUM_BUCKETS = void 0;
exports.NoDataState = NoDataState;
exports.yAxisFormatter = exports.useDateFormatter = exports.getDomain = exports.TIME_LABELS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _number = require("../../../../../common/custom_threshold_rule/formatters/number");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NUM_BUCKETS = exports.NUM_BUCKETS = 20;
const TIME_LABELS = exports.TIME_LABELS = {
  s: _i18n.i18n.translate('xpack.observability.customThreshold.rule..timeLabels.seconds', {
    defaultMessage: 'seconds'
  }),
  m: _i18n.i18n.translate('xpack.observability.customThreshold.rule..timeLabels.minutes', {
    defaultMessage: 'minutes'
  }),
  h: _i18n.i18n.translate('xpack.observability.customThreshold.rule..timeLabels.hours', {
    defaultMessage: 'hours'
  }),
  d: _i18n.i18n.translate('xpack.observability.customThreshold.rule..timeLabels.days', {
    defaultMessage: 'days'
  })
};
const useDateFormatter = (xMin, xMax) => {
  const dateFormatter = (0, _react.useMemo)(() => {
    if (typeof xMin === 'number' && typeof xMax === 'number') {
      return (0, _charts.niceTimeFormatter)([xMin, xMax]);
    } else {
      return value => `${value}`;
    }
  }, [xMin, xMax]);
  return dateFormatter;
};
exports.useDateFormatter = useDateFormatter;
const yAxisFormatter = exports.yAxisFormatter = _number.formatNumber;
const getDomain = (series, stacked = false) => {
  let min = null;
  let max = null;
  const valuesByTimestamp = series.reduce((acc, serie) => {
    serie.points.forEach(point => {
      const valuesForTimestamp = acc[point.timestamp] || [];
      acc[point.timestamp] = [...valuesForTimestamp, point.value];
    });
    return acc;
  }, {});
  const pointValues = Object.values(valuesByTimestamp);
  pointValues.forEach(results => {
    const maxResult = stacked ? (0, _lodash.sum)(results) : (0, _lodash.max)(results);
    const minResult = (0, _lodash.min)(results);
    if (maxResult && (!max || maxResult > max)) {
      max = maxResult;
    }
    if (minResult && (!min || minResult < min)) {
      min = minResult;
    }
  });
  const timestampValues = Object.keys(valuesByTimestamp).map(Number);
  const minTimestamp = (0, _lodash.min)(timestampValues) || 0;
  const maxTimestamp = (0, _lodash.max)(timestampValues) || 0;
  return {
    yMin: min || 0,
    yMax: max || 0,
    xMin: minTimestamp,
    xMax: maxTimestamp
  };
};
exports.getDomain = getDomain;
const EmptyContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  }
}, children);
exports.EmptyContainer = EmptyContainer;
const ChartContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150
  }
}, children);
exports.ChartContainer = ChartContainer;
function NoDataState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "thresholdRuleNoChartData"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule..charts.noDataMessage",
    defaultMessage: "No chart data available"
  })));
}
function LoadingState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "thresholdRuleLoadingData"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m"
  })));
}
function ErrorState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "thresholdRuleChartErrorState"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule..charts.errorMessage",
    defaultMessage: "Uh oh, something went wrong"
  })));
}