"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addPathParamToUrl = addPathParamToUrl;
exports.buildOnboardingPath = buildOnboardingPath;
exports.useCardUrlRewrite = useCardUrlRewrite;
var _deeplinksObservability = require("@kbn/deeplinks-observability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildOnboardingPath({
  category,
  search
}) {
  if (!category && !search) return '?';
  const params = new URLSearchParams();
  if (category) params.append('category', category);
  if (search) params.append('search', search);
  return `?${params.toString()}`;
}
function addPathParamToUrl(url, params) {
  const onboardingPath = buildOnboardingPath(params);
  const encoded = encodeURIComponent(onboardingPath);
  const paramsString = `returnAppId=${_deeplinksObservability.OBSERVABILITY_ONBOARDING_APP_ID}&returnPath=${encoded}`;
  if (url.indexOf('?') >= 0) {
    return `${url}&${paramsString}`;
  }
  return `${url}?${paramsString}`;
}
function useCardUrlRewrite(props) {
  const params = new URLSearchParams();
  if (props.category) params.append('category', props.category);
  if (props.search) params.append('search', props.search);
  return card => ({
    ...card,
    url: card.url.indexOf('/app/integrations') >= 0 ? addPathParamToUrl(card.url, {
      category: props.category,
      search: props.search
    }) : card.url
  });
}