"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingAppRoot = ObservabilityOnboardingAppRoot;
exports.renderApp = exports.onBoardingTitle = exports.breadcrumbsApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _ebtTools = require("@kbn/ebt-tools");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _header_action_menu = require("./shared/header_action_menu");
var _observability_onboarding_flow = require("./observability_onboarding_flow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onBoardingTitle = exports.onBoardingTitle = _i18n.i18n.translate('xpack.observability_onboarding.breadcrumbs.onboarding', {
  defaultMessage: 'Onboarding'
});
const breadcrumbsApp = exports.breadcrumbsApp = {
  id: 'observabilityOnboarding',
  label: onBoardingTitle
};
function ObservabilityOnboardingAppRoot({
  appMountParameters,
  core,
  corePlugins,
  config,
  context
}) {
  const {
    history,
    setHeaderActionMenu,
    theme$
  } = appMountParameters;
  const services = {
    ...core,
    ...corePlugins,
    config,
    context
  };
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    theme: {
      theme$
    },
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_ebtTools.PerformanceContextProvider, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_action_menu.ObservabilityOnboardingHeaderActionMenu, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }), /*#__PURE__*/_react.default.createElement(_observability_onboarding_flow.ObservabilityOnboardingFlow, null))))))));
}

/**
 * This module is rendered asynchronously in the Kibana platform.
 */

const renderApp = props => {
  const {
    element
  } = props.appMountParameters;
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(ObservabilityOnboardingAppRoot, props), element);
  return () => {
    props.corePlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;