"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorsStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/field-formats-plugin/common");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _help_icon = require("../../components/help_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessorsStats = ({
  stats
}) => {
  const durationFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DURATION);
  const items = stats.map((v, i) => {
    const key = Object.keys(v)[0];
    return {
      ...v[key],
      id: `${key}_${i}`
    };
  });
  const columns = [{
    field: 'type',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.pipelines.processorStats.typeHeader', {
      defaultMessage: 'Processor type'
    }),
    width: '100px',
    sortable: true,
    truncateText: false,
    render: type => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, type);
    },
    'data-test-subj': 'mlProcessorStatsType'
  }, {
    field: 'stats.count',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.countHeader",
      defaultMessage: "Count"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_help_icon.HelpIcon, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.countDescription",
        defaultMessage: "Total number of documents ingested during the lifetime of this node"
      })
    }))),
    width: '100px',
    truncateText: true,
    'data-test-subj': 'mlProcessorStatsCount'
  },
  /**
   * TODO Display when https://github.com/elastic/elasticsearch/issues/81037 is resolved
   */
  ...(true ? [] : [{
    field: 'stats.time_in_millis',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.timePerDocHeader",
      defaultMessage: "Time per doc"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_help_icon.HelpIcon, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.timePerDocDescription",
        defaultMessage: "Total time spent preprocessing ingest documents during the lifetime of this node"
      })
    }))),
    width: '100px',
    truncateText: false,
    'data-test-subj': 'mlProcessorStatsTimePerDoc',
    render: v => {
      return durationFormatter(v);
    }
  }]), {
    field: 'stats.current',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.currentHeader",
      defaultMessage: "Current"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_help_icon.HelpIcon, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.currentDescription",
        defaultMessage: "Total number of documents currently being ingested"
      })
    }))),
    width: '100px',
    truncateText: false,
    'data-test-subj': 'mlProcessorStatsCurrent'
  }, {
    field: 'stats.failed',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.failedHeader",
      defaultMessage: "Failed"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_help_icon.HelpIcon, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.pipelines.processorStats.failedDescription",
        defaultMessage: "Total number of failed ingest operations during the lifetime of this node"
      })
    }))),
    width: '100px',
    'data-test-subj': 'mlProcessorStatsFailed'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    columns: columns,
    items: items,
    itemId: 'id',
    rowProps: item => ({
      'data-test-subj': `mlProcessorStatsTableRow row-${item.id}`
    }),
    onTableChange: () => {},
    "data-test-subj": 'mlProcessorStatsTable'
  });
};
exports.ProcessorsStats = ProcessorsStats;