"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerNoResultsFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering EuiEmptyPrompt when no results were found.
 */
const ExplorerNoResultsFound = ({
  hasResults,
  selectedJobsRunning
}) => {
  const resultsHaveNoAnomalies = hasResults === true;
  const noResults = hasResults === false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement("h2", null, resultsHaveNoAnomalies && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.noAnomaliesFoundLabel",
      defaultMessage: "No anomalies found"
    }), noResults && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.noResultsFoundLabel",
      defaultMessage: "No results found"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedJobsRunning && noResults && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.selectedJobsRunningLabel",
      defaultMessage: "One or more selected jobs are still running and results may not be available yet."
    })), !selectedJobsRunning && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.tryWideningTimeSelectionLabel",
      defaultMessage: "Try widening the time selection or moving further back in time"
    })))
  });
};
exports.ExplorerNoResultsFound = ExplorerNoResultsFound;